module game;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :titlescreen;

namespace game
{
	titlescreen_t::titlescreen_t() : m_step(0)
	{
		this->m_process = GAME::PROCESS::TITLESCREEN;
	}

	titlescreen_t::~titlescreen_t()
	{
	}

	auto titlescreen_t::on_initialize() -> int32_t
	{
		return 0;
	}

	auto titlescreen_t::on_shutdown() -> int32_t
	{
		return 0;
	}

	auto titlescreen_t::on_start() -> int32_t
	{
		return 0;
	}

	auto titlescreen_t::on_stop() -> int32_t
	{
		return 0;
	}

	auto titlescreen_t::on_update() -> GAME::STATE
	{
		if (this->m_step != GAME::TITLESCREEN::STEP::TITLE)
		{
			ALLEGRO::BITMAP target = al::get_target_bitmap();
			ALLEGRO::SIZE<int32_t> tsize = al::get_bitmap_dimensions(target);
			al::set_target_bitmap(game_shared_data_t::get_buffer());
			ALLEGRO::SIZE<int32_t> bsize = al::get_bitmap_dimensions(game_shared_data_t::get_buffer());

			al::clear_to_color(wind::map_rgb_i(0x000000));

			while (this->m_step < GAME::TITLESCREEN::STEP::TITLE)
			{
				al::set_target_bitmap(game_shared_data_t::get_buffer());
				this->on_render();
				al::set_target_bitmap(target);
				al::draw_scaled_bitmap(game_shared_data_t::get_buffer(),
					{ {0, 0}, bsize },
					{ { 0, 0 }, tsize });

				game::faders::out();
				
				++this->m_step;

				al::set_target_bitmap(game_shared_data_t::get_buffer());
				this->on_render();
				al::set_target_bitmap(target);
				al::draw_scaled_bitmap(game_shared_data_t::get_buffer(),
					{ {0, 0}, bsize },
					{ { 0, 0 }, tsize });
				game::faders::in();
				al::rest(0.5);
			}
			wind::input::acknowledge();
			wind::system::timer::reset();
		}
		else
		{
			if (wind::input::keyboard::was_released(ALLEGRO::KEY_ENTER))
			{
				wind::input::keyboard::acknowledge(ALLEGRO::KEY_ENTER);
				return GAME::STATE::BOARDGAME;
			}
		}

		return GAME::STATE::TITLE_SCREEN;
	}

	auto titlescreen_t::on_render() -> void
	{
		static const int32_t bitmap_index[GAME::TITLESCREEN::STEP::COUNT] =
		{
			GAME::DATAFILE::TITLE_HARMON,
			GAME::DATAFILE::TITLE_RATING,
			GAME::DATAFILE::TITLE_SCREEN
		};

		ALLEGRO::BITMAP target = al::get_target_bitmap();
		ALLEGRO::SIZE<int32_t> tsize = al::get_bitmap_dimensions(target);
		ALLEGRO::BITMAP overlay = std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game_shared_data_t::get_datafile()[bitmap_index[this->m_step]]);
		ALLEGRO::SIZE<int32_t> osize = al::get_bitmap_dimensions(overlay);

		if (this->m_step == GAME::TITLESCREEN::TITLE)
		{
			ALLEGRO::BITMAP background = std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game_shared_data_t::get_datafile()[GAME::DATAFILE::SHARED_BACKGROUND]);
			ALLEGRO::POINT<size_t> position{ 0,0 };
			ALLEGRO::SIZE<size_t> bgsize = al::get_bitmap_dimensions(background);

			for (position.y = 0; position.y <= osize.height; position.y += bgsize.height)
			{
				for (position.x = 0; position.x <= osize.width; position.x += bgsize.width)
				{
					al::draw_bitmap(background, position);
				}
			}
		}

		if (this->m_step == GAME::TITLESCREEN::RATING)
		{
			al::clear_to_color(wind::map_rgb_i(0x000000));
			al::draw_bitmap(overlay, { (tsize.width - osize.width) >> 1, (tsize.height - osize.height) >> 1 });
		}
		else
		{
			al::draw_scaled_bitmap(overlay, { {0, 0}, osize }, { {0, 0}, tsize });
		}
	}

	auto titlescreen_t::get_viewport() -> ALLEGRO::SIZE<int32_t>
	{
		return GAME::BUFFER::SIZE;
	}
}