module game;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :datafile;
import :game_shared_data;

namespace game
{
	wind::datafile_t game_shared_data_t::m_datafile{};
	ALLEGRO::BITMAP game_shared_data_t::m_buffer{};
	ALLEGRO::POINT<float> game_shared_data_t::m_mouse{ 0, 0 };
	wind::console::font_t game_shared_data_t::m_font{};
	dungeon::dungeon_shared_data_t game_shared_data_t::m_dungeon{};

	game_shared_data_t::game_shared_data_t()
	{
	}

	game_shared_data_t::~game_shared_data_t()
	{
	}

	auto game_shared_data_t::get_datafile() -> const wind::datafile_t&
	{
		return game_shared_data_t::m_datafile;
	}

	auto game_shared_data_t::get_buffer() -> const ALLEGRO::BITMAP&
	{
		return game_shared_data_t::m_buffer;
	}

	auto game_shared_data_t::get_mouse() -> const ALLEGRO::POINT<float>&
	{
		return game_shared_data_t::m_mouse;
	}

	auto game_shared_data_t::get_font() -> const wind::console::font_t
	{
		return game_shared_data_t::m_font;
	}

	auto game_shared_data_t::get_dungeon_data() -> const dungeon::dungeon_shared_data_t&
	{
		return game_shared_data_t::m_dungeon;
	}

	auto game_shared_data_t::set_dungeon_data(const dungeon::dungeon_shared_data_t& data) -> void
	{
		game_shared_data_t::m_dungeon = data;
	}

	auto game_shared_data_t::reset() -> void
	{
		game_shared_data_t::m_datafile.clear();
		game_shared_data_t::m_buffer.reset();
		game_shared_data_t::m_mouse = { 0, 0 };
		game_shared_data_t::m_font.reset();
		game_shared_data_t::m_dungeon.reset();
	}
}
