module game;

import <cstdint>;
import <vector>;
import <memory>;
import <string>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.trigger.base;
import :dungeon.trigger.skeleton;

namespace game
{
	namespace dungeon
	{
		namespace trigger
		{
			const char* skeleton_t::note{ "A note reads:" };
			const char* skeleton_t::greeting{ "Hello, adventurer," };
			const char* skeleton_t::text{ "You also have ventured into this dark endless dungeon. "
								"I have barred the door, but I hear them. I am too weak to go on. If you "
								"are brave, take my sword. Also, this key. I pray you will do better than "
								"I did. May we meet under brighter skies in the after word ..." };

			skeleton_t::skeleton_t()
			{
				this->m_type = GAME::DUNGEON::TRIGGER::TYPE::INVALID;
				this->m_state = GAME::DUNGEON::TRIGGER::STATE::INVALID;
				this->m_index = -1;
				this->m_flags = 0;
			}

			skeleton_t::~skeleton_t()
			{
			}

			auto skeleton_t::evoke() -> int32_t
			{
				return 0;
			}

			auto skeleton_t::shutdown() -> void
			{
			}

			auto skeleton_t::on_update() -> void
			{
				if (wind::input::keyboard::was_pressed(ALLEGRO::KEY_ESCAPE))
				{
					wind::input::keyboard::acknowledge(ALLEGRO::KEY_ESCAPE);
					this->m_state = GAME::DUNGEON::TRIGGER::STATE::DEACTIVATED;
				}
			}

			auto skeleton_t::on_render() -> void
			{
				static std::vector<wind::string_t> vector{};

				if (vector.empty())
				{
					std::vector<wind::string_t> temp{};
					wind::string::separate(skeleton_t::text, temp, ' ');
					wind::string_t p{};

					for (auto s : temp)
					{
						size_t l = p.length();
						size_t k = s.length();
						if (l + k + 1 <= 34)
						{
							p.append(s);
							if (p.length() < 34)
							{
								p.push_back(' ');
							}
						}
						else
						{
							vector.push_back(p);
							p = s;
							p.push_back(' ');
						}
					}
					if (!p.empty())
					{
						vector.push_back(p);
					}
				}

				ALLEGRO::RECTANGLE<int32_t> region{ {0, 0}, { GAME::DUNGEON::CAMERA::VIEWPORT.width << GAME::DUNGEON::TILE::SHIFT.x, GAME::DUNGEON::CAMERA::VIEWPORT.height << GAME::DUNGEON::TILE::SHIFT.y } };
				region.position.x = 32;
				region.position.y = 32;
				region.size.width -= (region.position.x << 1);
				region.size.height -= (region.position.y << 1);

				ALLEGRO::BITMAP background = std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game::game_shared_data_t::get_datafile()[GAME::DATAFILE::SHARED_BACKGROUND]);
				wind::bitmap::flood_fill(background, region);

				const wind::console::font_t& font = game_shared_data_t::get_font();

				ALLEGRO::POINT<int32_t> point{ 40, 32 + 8 };

				wind::console::draw_font(font, wind::map_rgb_i(0x12121d), { point.x + 1, point.y + 1 }, WIND::CONSOLE::FONT_ALIGNMENT_LEFT, skeleton_t::note);
				wind::console::draw_font(font, wind::map_rgb_i(0xfcfcfc), point, WIND::CONSOLE::FONT_ALIGNMENT_LEFT, skeleton_t::note);

				point.x = (32 + (region.size.width >> 1));
				point.y += 16;

				wind::console::draw_font(font, wind::map_rgb_i(0x12121d), { point.x + 1, point.y + 1 }, WIND::CONSOLE::FONT_ALIGNMENT_CENTRE, skeleton_t::greeting);
				wind::console::draw_font(font, wind::map_rgb_i(0xfcfcfc), point, WIND::CONSOLE::FONT_ALIGNMENT_CENTRE, skeleton_t::greeting);

				point.y += 2 * 16;

				for (auto s : vector)
				{
					wind::console::draw_font(font, wind::map_rgb_i(0x12121d), { point.x + 1, point.y + 1 }, WIND::CONSOLE::FONT_ALIGNMENT_CENTRE, s);
					wind::console::draw_font(font, wind::map_rgb_i(0xfcfcfc), point, WIND::CONSOLE::FONT_ALIGNMENT_CENTRE, s);

					point.y += 2 * 8;

				}



				


				

			}
		}
	}
}