module game;

import <cstdint>;
import <vector>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.trigger.base;
import :dungeon.trigger.chest;

namespace game
{
	namespace dungeon
	{
		namespace trigger
		{
			chest_t::chest_t() : m_data()
			{
				this->m_type = GAME::DUNGEON::TRIGGER::TYPE::INVALID;
				this->m_state = GAME::DUNGEON::TRIGGER::STATE::INVALID;
				this->m_index = -1;
				this->m_flags = 0;
			}

			chest_t::~chest_t()
			{
			}

			auto chest_t::evoke() -> int32_t
			{
				return 0;
			}

			auto chest_t::shutdown() -> void
			{
			}

			auto chest_t::on_update() -> void
			{
			}

			auto chest_t::on_render() -> void
			{
			}

			auto chest_t::clear() -> void
			{
				this->m_data.clear();
			}

			auto chest_t::data() -> void*
			{
				return this->m_data.get_data();
			}

			auto chest_t::data() const -> const void*
			{
				return this->m_data.get_data();
			}

			auto chest_t::size() const -> size_t
			{
				return this->m_data.get_count();
			}

			auto chest_t::at(size_t index) -> chest_t::reference_element_type
			{
				ALLEGRO::ASSERT(index < this->m_data.get_count());
				return this->m_data[index];
			}

			auto chest_t::at(size_t index) const -> chest_t::const_reference_element_type
			{
				ALLEGRO::ASSERT(index < this->m_data.get_count());
				return this->m_data[index];
			}

			auto chest_t::operator [](size_t index) -> chest_t::reference_element_type
			{
				ALLEGRO::ASSERT(index < this->m_data.get_count());
				return this->m_data[index];
			}

			auto chest_t::operator [](size_t index) const -> chest_t::const_reference_element_type
			{
				ALLEGRO::ASSERT(index < this->m_data.get_count());
				return this->m_data[index];
			}

			auto chest_t::begin() -> chest_t::iterator
			{
				return iterator(this->m_data, 0);
			}

			auto chest_t::end() -> chest_t::iterator
			{
				return iterator(this->m_data, this->m_data.get_count() - 1);
			}

			auto chest_t::cbegin() const -> chest_t::const_iterator
			{
				return const_iterator(this->m_data, 0);
			}

			auto chest_t::cend() const -> chest_t::const_iterator
			{
				return const_iterator(this->m_data, this->m_data.get_count() - 1);
			}
		}
	}
}