module game;

import <cstdint>;
import <vector>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.trigger;

namespace game
{
	namespace dungeon
	{
		trigger_tag_t::trigger_tag_t() : m_type(GAME::DUNGEON::TRIGGER::TYPE::INVALID),
			m_state(GAME::DUNGEON::TRIGGER::STATE::INVALID),
			m_index(-1),
			m_flags(0)
		{
		}

		trigger_tag_t::~trigger_tag_t()
		{
		}

		auto trigger_tag_t::get_type() const->GAME::DUNGEON::TRIGGER::TYPE
		{
			return this->m_type;
		}

		auto trigger_tag_t::set_type(GAME::DUNGEON::TRIGGER::TYPE type) -> void
		{
			this->m_type = type;
		}

		auto trigger_tag_t::get_state() const->GAME::DUNGEON::TRIGGER::STATE
		{
			return this->m_state;
		}

		auto trigger_tag_t::set_state(GAME::DUNGEON::TRIGGER::STATE state) -> void
		{
			this->m_state = state;
		}

		auto trigger_tag_t::get_index() const->int32_t
		{
			return this->m_index;
		}

		auto trigger_tag_t::set_index(int32_t index) -> void
		{
			this->m_index = index;
		}

		auto trigger_tag_t::get_flags() const->int32_t
		{
			return this->m_flags;
		}

		auto trigger_tag_t::set_flags(int32_t flags) -> void
		{
			this->m_flags = flags;
		}
	}
}