module game;

import <cstdint>;
import <vector>;
import <memory>;
import <array>;
import <map>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item.base;
import :dungeon.dungeon_shared_data;

namespace game
{
	namespace dungeon
	{
		dungeon_shared_data_tag_t::dungeon_shared_data_tag_t()
		{
		}

		dungeon_shared_data_tag_t::~dungeon_shared_data_tag_t()
		{
		}

		auto dungeon_shared_data_tag_t::get_icon_tilesheet(GAME::DUNGEON::ITEM::TYPE type) const -> const item::icon::tilesheet_t&
		{
			ALLEGRO::ASSERT(std::to_underlying(type) >= 0 && std::to_underlying(type) < std::to_underlying(GAME::DUNGEON::ITEM::TYPE::COUNT));
			return this->m_icon_tilesheets[std::to_underlying(type)];
		}

		auto dungeon_shared_data_tag_t::get_icon_index(GAME::DUNGEON::ITEM::TYPE type, const wind::string_t& name) const -> int32_t
		{
			ALLEGRO::ASSERT(std::to_underlying(type) >= 0 && std::to_underlying(type) < std::to_underlying(GAME::DUNGEON::ITEM::TYPE::COUNT));

			auto arr = this->m_icon_name_maps[std::to_underlying(type)];

			auto it = arr.find(name);
			if (it == arr.cend())
			{
				return -1;
			}

			return it->second;
		}

		auto dungeon_shared_data_tag_t::set_icon_tilesheet(GAME::DUNGEON::ITEM::TYPE type, const item::icon::tilesheet_t& tilesheet) -> void
		{
			ALLEGRO::ASSERT(std::to_underlying(type) >= 0 && std::to_underlying(type) < std::to_underlying(GAME::DUNGEON::ITEM::TYPE::COUNT));
			this->m_icon_tilesheets[std::to_underlying(type)] = tilesheet;
		}

		auto dungeon_shared_data_tag_t::get_icon_name_map(GAME::DUNGEON::ITEM::TYPE type) -> item::icon::name_map_t&
		{
			ALLEGRO::ASSERT(std::to_underlying(type) >= 0 && std::to_underlying(type) < std::to_underlying(GAME::DUNGEON::ITEM::TYPE::COUNT));

			item::icon::name_map_t& map = this->m_icon_name_maps.at(std::to_underlying(type));

			return map;
		}

		auto dungeon_shared_data_tag_t::get_icon_name_map(GAME::DUNGEON::ITEM::TYPE type) const -> const item::icon::name_map_t&
		{
			ALLEGRO::ASSERT(std::to_underlying(type) >= 0 && std::to_underlying(type) < std::to_underlying(GAME::DUNGEON::ITEM::TYPE::COUNT));
			return this->m_icon_name_maps.at(std::to_underlying(type));
		}

		auto dungeon_shared_data_tag_t::reset() -> void
		{
			for (auto t : this->m_icon_tilesheets)
			{
				t.reset();
			}

			for (auto n : this->m_icon_name_maps)
			{
				n.clear();
			}
		}
	}
}
