module game;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :dungeon.base;
import :dungeon.item;
import :dungeon.player.data;

namespace game
{
	namespace dungeon
	{
		namespace player
		{
			data_tag_t::data_tag_t()
			{
			}

			data_tag_t::~data_tag_t()
			{
			}

			auto data_tag_t::get_items() const -> const std::array<item_t, GAME::DUNGEON::INVENTORY::COUNT>&
			{
				return this->m_items;
			}

			auto data_tag_t::get_items() -> std::array<item_t, GAME::DUNGEON::INVENTORY::COUNT>&
			{
				return this->m_items;
			}

			auto data_tag_t::get_slot(size_t slot_index) -> item_t&
			{
				ALLEGRO::ASSERT(slot_index < GAME::DUNGEON::INVENTORY::COUNT);
				return this->m_items[slot_index];
			}

			auto data_tag_t::get_slot(size_t slot_index) const -> const item_t&
			{
				ALLEGRO::ASSERT(slot_index < GAME::DUNGEON::INVENTORY::COUNT);
				return this->m_items[slot_index];
			}

			auto data_tag_t::get_key() const -> bool
			{
				return this->m_key;
			}

			auto data_tag_t::set_key(bool key) -> void
			{
				this->m_key = key;
			}

			auto data_tag_t::get_money() const->int32_t
			{
				return this->m_money;
			}

			auto data_tag_t::set_money(int32_t money) -> void
			{
				this->m_money = money;
			}

			auto data_tag_t::get_floor() -> int32_t
			{
				return this->m_floor;
			}

			auto data_tag_t::set_floor(int32_t floor) -> void
			{
				this->m_floor = floor;
			}
		}
	}
}