module game;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.movable;
import :dungeon.map;
import :dungeon.player;
import :dungeon.item;
import :dungeon.player;

namespace game
{
	namespace dungeon
	{
		player_t::player_t()
		{
		}

		player_t::~player_t()
		{
		}

		auto player_t::on_initialize() -> int32_t
		{
			this->m_data = std::make_shared<player::data_tag_t>();
			if (!this->m_data)
			{
				return -1;
			}

			return 0;
		}

		auto player_t::on_shutdown() -> void
		{
			this->m_data.reset();
			movable_t::on_shutdown();
		}

		auto player_t::on_update() -> void
		{
			if (this->m_moved)
			{
				this->m_frame = (this->m_frame + 1) % 2;
				this->m_moved = false;
			}
		}

		auto player_t::on_render(const map::camera_t& camera, const ALLEGRO::POINT<float>& position) const -> void
		{
			ALLEGRO::POINT<float> tpos = { this->m_frame << GAME::BOARDGAME::TILE::SHIFT.x, (int32_t)this->m_facing << GAME::BOARDGAME::TILE::SHIFT.y };
			ALLEGRO::POINT<float> ppos = { (int32_t)(this->m_position.x - camera.get_position().x) << GAME::BOARDGAME::TILE::SHIFT.x, (int32_t)(this->m_position.y - camera.get_position().y) << GAME::BOARDGAME::TILE::SHIFT.y };

			al::draw_bitmap_region(this->m_bitmap, { tpos, {GAME::BOARDGAME::TILE::SIZE.width, GAME::BOARDGAME::TILE::SIZE.height} }, position + ppos);
		}

		auto player_t::get_data() const -> const player::data_t&
		{
			return this->m_data;
		}

		auto player_t::get_data() -> player::data_t&
		{
			return this->m_data;
		}
	}
}
