module game;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.map;
import :dungeon.movable;

namespace game
{
	namespace dungeon
	{
		movable_t::movable_t() :
			m_bitmap(),
			m_position({ 0, 0 }),
			m_hp(0),
			m_max_hp(0),
			m_facing(GAME::DIRECTION::INVALID),
			m_frame(0)
		{
		}

		movable_t::~movable_t()
		{
		}

		auto movable_t::on_shutdown() -> void
		{
			this->m_bitmap.reset();
		}

		auto movable_t::get_bitmap() const -> const ALLEGRO::BITMAP&
		{
			return this->m_bitmap;
		}

		auto movable_t::get_position() const -> const ALLEGRO::POINT<float>&
		{
			return this->m_position;
		}

		auto movable_t::get_x() const->int32_t
		{
			return this->m_position.x;
		}

		auto movable_t::get_y() const->int32_t
		{
			return this->m_position.y;
		}

		auto movable_t::get_hp() const->int32_t
		{
			return this->m_hp;
		}

		auto movable_t::get_max_hp() const->int32_t
		{
			return this->m_max_hp;
		}

		auto movable_t::get_facing() const->GAME::DIRECTION
		{
			return this->m_facing;
		}

		auto movable_t::get_frame() const->int32_t
		{
			return this->m_frame;
		}

		auto movable_t::set_position(const ALLEGRO::POINT<float>& position) -> void
		{
			this->m_position = position;
		}

		auto movable_t::set_bitmap(const ALLEGRO::BITMAP& bitmap) -> void
		{
			this->m_bitmap = bitmap;
		}

		auto movable_t::set_x(int32_t value) ->void
		{
			this->m_position.x = value;
		}

		auto movable_t::set_y(int32_t value) ->void
		{
			this->m_position.y = value;
		}

		auto movable_t::set_hp(int32_t value) ->void
		{
			this->m_hp = value;
		}

		auto movable_t::set_max_hp(int32_t value) ->void
		{
			this->m_max_hp = value;
		}

		auto movable_t::set_facing(GAME::DIRECTION value) ->void
		{
			if (this->m_facing != value)
			{
				this->m_facing = value;
				this->m_frame = 0;
			}
		}

		auto movable_t::set_frame(int32_t value) ->void
		{
			this->m_frame = value;
		}

		auto movable_t::get_moved() const -> bool
		{
			return this->m_moved;
		}

		auto movable_t::set_moved(bool value) -> void
		{
			this->m_moved = value;
		}
	}
}