module game;

import <cstdint>;
import <memory>;
import allegro;
import allegro.primitives_addon;
import wind;
import :base;
import :dungeon.base;
import :dungeon.map;
import :dungeon.map.generator;

namespace game
{
	namespace dungeon
	{
		auto map_t::draw(const std::shared_ptr<wind::tilesheet_t>& tilesheet, const map::camera_t& camera, const ALLEGRO::POINT<int32_t>& position) const -> void
		{
			const ALLEGRO::POINT<float>& cpos = camera.get_position();

			for (size_t j = 0; j <= GAME::DUNGEON::CAMERA::VIEWPORT.height; ++j)
			{
				for (size_t i = 0; i <= GAME::DUNGEON::CAMERA::VIEWPORT.width; ++i)
				{
					int32_t index = this->get_index({ (cpos.x + i), (cpos.y + j) });

					if (index < 0)
					{
						continue;
					}

					ALLEGRO::POINT<int32_t> ipos{ (i << GAME::BOARDGAME::TILE::SHIFT.x), (j << GAME::BOARDGAME::TILE::SHIFT.y) };
					ALLEGRO::POINT<int32_t> point{ position + ipos };

					this->m_data.get()[index].draw(tilesheet, point);
				}
			}
		}
	}
}