module game;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.map.cell;

namespace game
{
	namespace dungeon
	{
		namespace map
		{
			cell_t::cell_t() : m_data()
			{
			}

			cell_t::cell_t(uint32_t value) : m_data()
			{
				this->m_data.m_value = value;
			}

			cell_t::cell_t(const cell::shared_data_t& data) : m_data(data)
			{
			}

			cell_t::cell_t(const cell_t& cell) : m_data(cell.m_data)
			{
			}

			cell_t::~cell_t()
			{
			}

			auto cell_t::operator = (const cell_t& cell) -> cell_t&
			{
				this->m_data.m_value = cell.m_data.m_value;
				return *this;
			}

			cell_t::operator uint32_t () const
			{
				return this->m_data.m_value;
			}

			cell_t::operator const cell::shared_data_t& () const
			{
				return this->m_data;
			}

			auto cell_t::set_value(uint32_t value) -> void
			{
				this->m_data.m_value = value;
			}

			auto cell_t::get_value() const->uint32_t
			{
				return this->m_data.m_value;
			}

			auto cell_t::set_attribute(size_t index, uint32_t value) -> void
			{
				switch (index)
				{
				case GAME::DUNGEON::CELL::ATTRIBUTE::VISIBLE:
				{
					this->m_data.m_visible = value;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::EDGE:
				{
					this->m_data.m_edge = value;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::FLOOR:
				{
					this->m_data.m_floor = value;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::TILE:
				{
					this->m_data.m_wall = value;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::OBJECT:
				{
					this->m_data.m_object = value;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::BLOCKED:
				{
					this->m_data.m_blocked = value;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::NPC:
				{
					this->m_data.m_npc = value;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::TRIGGER:
				{
					this->m_data.m_trigger = value;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::FLUFF:
				{
					this->m_data.m_fluff = value;
				} break;
				}
			}

			auto cell_t::get_attribute(size_t index) const->uint32_t
			{
				uint32_t rv = 0;

				switch (index)
				{
				case GAME::DUNGEON::CELL::ATTRIBUTE::VISIBLE:
				{
					rv = this->m_data.m_visible;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::EDGE:
				{
					rv = this->m_data.m_edge;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::FLOOR:
				{
					rv = this->m_data.m_floor;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::TILE:
				{
					rv = this->m_data.m_wall;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::OBJECT:
				{
					rv = this->m_data.m_object;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::BLOCKED:
				{
					rv = this->m_data.m_blocked;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::NPC:
				{
					rv = this->m_data.m_npc;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::TRIGGER:
				{
					rv = this->m_data.m_trigger;
				} break;
				case GAME::DUNGEON::CELL::ATTRIBUTE::FLUFF:
				{
					rv = this->m_data.m_fluff;
				} break;
				}

				return rv;
			}

			auto cell_t::get_visible() const->uint32_t
			{
				return this->m_data.m_visible;
			}

			auto cell_t::get_edge() const->uint32_t
			{
				return this->m_data.m_edge;
			}

			auto cell_t::get_floor_tile() const->uint32_t
			{
				return this->m_data.m_floor;
			}

			auto cell_t::get_wall_tile() const->uint32_t
			{
				return this->m_data.m_wall;
			}

			auto cell_t::get_object_tile() const->uint32_t
			{
				return this->m_data.m_object;
			}

			auto cell_t::get_blocked() const->uint32_t
			{
				return this->m_data.m_blocked;
			}

			auto cell_t::get_npc() const->uint32_t
			{
				return this->m_data.m_npc;
			}

			auto cell_t::get_trigger() const->uint32_t
			{
				return this->m_data.m_trigger;
			}

			auto cell_t::get_fluff() const->uint32_t
			{
				return this->m_data.m_fluff;
			}

			auto cell_t::set_visible(uint32_t value) -> void
			{
				this->m_data.m_visible = value;
			}

			auto cell_t::set_edge(uint32_t value) -> void
			{
				this->m_data.m_edge = value;
			}

			auto cell_t::set_floor_tile(uint32_t value) -> void
			{
				this->m_data.m_floor = value;
			}

			auto cell_t::set_wall_tile(uint32_t value) -> void
			{
				this->m_data.m_wall = value;
			}

			auto cell_t::set_object_tile(uint32_t value) -> void
			{
				this->m_data.m_object = value;
			}

			auto cell_t::set_blocked(uint32_t value) -> void
			{
				this->m_data.m_blocked = value;
			}

			auto cell_t::set_npc(uint32_t value) -> void
			{
				this->m_data.m_npc = value;
			}

			auto cell_t::set_trigger(uint32_t value) -> void
			{
				this->m_data.m_trigger = value;
			}

			auto cell_t::set_fluff(uint32_t value) -> void
			{
				this->m_data.m_fluff = value;
			}

			auto cell_t::draw(const std::shared_ptr<wind::tilesheet_t>& tilesheet, const ALLEGRO::POINT<int32_t>& position, bool debug_mode) const -> void
			{
				if (this->m_data.m_visible)
				{
					if (this->m_data.m_floor)
					{
						const ALLEGRO::BITMAP& bitmap = tilesheet->at(this->m_data.m_floor);
						al::draw_bitmap(bitmap, position);
					}

					if (this->m_data.m_wall)
					{
						const ALLEGRO::BITMAP& bitmap = tilesheet->at(this->m_data.m_wall);
						al::draw_bitmap(bitmap, position);
					}

					if (this->m_data.m_object)
					{
						const ALLEGRO::BITMAP& bitmap = tilesheet->at(this->m_data.m_object);
						al::draw_bitmap(bitmap, position);
					}
				}
			}
		}
	}
}