module game;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.map.camera;

namespace game
{
	namespace dungeon
	{
		namespace map
		{
			camera_t::camera_t() : m_player(), m_velocity({ 0.0f, 0.0f }), m_position({ 0.0f, 0.0f })
			{
			}

			camera_t::camera_t(const camera_t& camera) : m_player(camera.m_player), m_velocity(camera.m_velocity), m_position(camera.m_position)
			{
			}

			camera_t::~camera_t()
			{
			}

			camera_t& camera_t::operator = (const camera_t& camera)
			{
				this->m_player = camera.m_player;
				this->m_velocity = camera.m_velocity;
				this->m_position = camera.m_position;

				return *this;
			}

			camera_t& camera_t::operator = (const ALLEGRO::POINT<float>& position)
			{
				this->m_position = position;

				return *this;
			}

			auto camera_t::follow(const ALLEGRO::POINT<float>& player) -> void
			{
				this->m_player = std::shared_ptr<const ALLEGRO::POINT<float>>(&player, wind::null_deleter< const ALLEGRO::POINT<float>>);
			}

			auto camera_t::update() -> void
			{
				static constexpr ALLEGRO::POINT<float> delta = { (float)(GAME::DUNGEON::CAMERA::VIEWPORT.width >> 1), (float)(GAME::DUNGEON::CAMERA::VIEWPORT.height >> 1) };
				const ALLEGRO::POINT<float> player{ *this->m_player.get() - delta };


				this->m_position.x = std::max(std::min(this->m_position.x, player.x + 2), player.x - 2);
				this->m_position.y = std::max(std::min(this->m_position.y, player.y + 1), player.y - 1);
			}

			auto camera_t::move(const ALLEGRO::POINT<float>& delta) -> void
			{
				this->m_position += delta;
			}

			auto camera_t::get_position() const->const ALLEGRO::POINT<float>&
			{
				return this->m_position;
			}

			auto camera_t::set_position(const ALLEGRO::POINT<float>& position) -> void
			{
				this->m_position = position;
			}
		}
	}
}