module game;

import <cstdint>;
import <array>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.level;

namespace game
{
	namespace dungeon
	{
		level_t::level_t() : m_rooms()
		{
		}

		level_t::level_t(const level_t& level) : m_rooms(level.m_rooms)
		{
		}

		level_t::~level_t()
		{
		}

		auto level_t::operator = (const level_t& level) -> level_t&
		{
			this->m_rooms = level.m_rooms;

			return *this;
		}

		auto level_t::clear() -> void
		{
			this->m_rooms.clear();
		}

		auto level_t::count() const -> size_t
		{
			return this->m_rooms.size();
		}

		auto level_t::operator[](size_t index) -> level_t::reference_element_type
		{
			ALLEGRO::ASSERT(index < this->m_rooms.size());
			return *(this->m_rooms[index].get());
		}

		auto level_t::operator[](size_t index) const -> level_t::const_reference_element_type
		{
			ALLEGRO::ASSERT(index < this->m_rooms.size());
			return *(this->m_rooms[index].get());
		}

		auto level_t::at(size_t index) -> level_t::reference_element_type
		{
			ALLEGRO::ASSERT(index < this->m_rooms.size());
			return *(this->m_rooms[index].get());
		}

		auto level_t::at(size_t index) const -> level_t::const_reference_element_type
		{
			ALLEGRO::ASSERT(index < this->m_rooms.size());
			return *(this->m_rooms[index].get());
		}

		auto level_t::push_back(level_t::const_reference_element_type room) -> void
		{
			std::shared_ptr<level_t::element_type> r = std::make_shared<level_t::element_type>(room);
			ALLEGRO::ASSERT(r);
			this->m_rooms.push_back(r);
		}

		auto level_t::pop_back() -> void
		{
			ALLEGRO::ASSERT(this->m_rooms.size());
			this->m_rooms.pop_back();
		}

		auto level_t::get_data() const -> const void*
		{
			return this->m_rooms.data();
		}

		auto level_t::get_data() -> void*
		{
			return this->m_rooms.data();
		}

		auto level_t::begin() ->level_t::iterator
		{
			return level_t::iterator(this->m_rooms.begin());
		}

		auto level_t::end() ->level_t::iterator
		{
			return level_t::iterator(this->m_rooms.end());
		}

		auto level_t::cbegin() const->level_t::const_iterator
		{
			return level_t::const_iterator(this->m_rooms.cbegin());
		}

		auto level_t::cend() const->level_t::const_iterator
		{
			return level_t::const_iterator(this->m_rooms.cend());
		}
	}
}