module game;

import <cstdint>;
import <vector>;
import <memory>;
import <map>;
import allegro;
import allegro.physfs_addon;
import wind;
import :base;
import :game_shared_data;
import :dungeon.base;
import :dungeon.dungeon_shared_data;
import :dungeon.item.base;
import :dungeon.item.icons;


namespace game
{
	namespace dungeon
	{
		namespace item
		{
			namespace icon
			{
				auto get_index(GAME::DUNGEON::ITEM::TYPE type, const wind::string_t& name) -> int32_t
				{
					return game_shared_data_t::get_dungeon_data()->get_icon_index(type, name);
				}

				const ALLEGRO::BITMAP m_error{};

				auto get_bitmap(GAME::DUNGEON::ITEM::TYPE type, int32_t index) -> const ALLEGRO::BITMAP&
				{
					const item::icon::tilesheet_t& tilesheet = game_shared_data_t::get_dungeon_data()->get_icon_tilesheet(type);

					if (tilesheet && tilesheet->count() && index >= 0 && index < tilesheet->count())
					{
						return tilesheet->at(index);

					}
					return m_error;
				}

				auto set_tilesheet(GAME::DUNGEON::ITEM::TYPE type, const item::icon::tilesheet_t& tilesheet) -> void
				{
					game_shared_data_t::get_dungeon_data()->set_icon_tilesheet(type, tilesheet);
				}

				auto load(const wind::string_t& filename, dungeon::item::icon::name_map_t& map) -> int32_t
				{
					wind::json_t json{};

					if (!al::filename_exists((wind::string_t(GAME::MANIFESTS_DIRECTORY) + "\\" + filename).c_str()))
					{
						return -1;
					}

					if (wind::json::load(json, wind::string_t(GAME::MANIFESTS_DIRECTORY) + "\\" + filename) < 0)
					{
						return -1;
					}

					if (json.get_type() != WIND::JSON::TYPE_OBJECT)
					{
						return -1;
					}

					const wind::json_object_t& object = json.get_as_object();

					auto file_it = object.find("icons");
					if (file_it == object.cend())
					{
						return -1;
					}

					if (file_it->get_type() != WIND::JSON::TYPE_ARRAY)
					{
						return -1;
					}

					const wind::json_array_t& file_array = file_it->get_as_array();
					int32_t index{ 0 };

					for (auto it = file_array.cbegin(); it != file_array.cend(); ++it)
					{
						if (it->get_type() != WIND::JSON::TYPE_STRING)
						{
							return -1;
						}

						const wind::string_t& name_s = it->get_as_string();
						map.insert(std::pair(name_s, index));
						++index;
					}

					return 0;
				}

				auto load(const wind::string_t& filename) -> int32_t
				{
					const std::map<wind::string_t, int32_t> m_indexes
					{ {
						{ "armor", std::to_underlying(GAME::DUNGEON::ITEM::TYPE::ARMOR) },
						{ "food", std::to_underlying(GAME::DUNGEON::ITEM::TYPE::FOOD) },
						{ "potion", std::to_underlying(GAME::DUNGEON::ITEM::TYPE::POTION) },
						{ "treasure", std::to_underlying(GAME::DUNGEON::ITEM::TYPE::TREASURE) },
						{ "weapon", std::to_underlying(GAME::DUNGEON::ITEM::TYPE::WEAPON) }
					} };

					wind::json_t json{};

					if (!al::filename_exists(filename.c_str()))
					{
						return -1;
					}

					if (wind::json::load(json, filename) < 0)
					{
						return -1;
					}

					if (json.get_type() != WIND::JSON::TYPE_OBJECT)
					{
						return -1;
					}

					const wind::json_object_t& object = json.get_as_object();

					auto files_it = object.find("files");

					if (files_it == object.cend())
					{
						return -1;
					}

					if (files_it->get_type() != WIND::JSON::TYPE_ARRAY)
					{
						return -1;
					}

					const wind::json_array_t& file_array = files_it->get_as_array();

					for (auto it = file_array.cbegin(); it != file_array.cend(); ++it)
					{
						wind::string_t type_s{};
						wind::string_t file_s{};

						if (it->get_type() != WIND::JSON::TYPE_OBJECT)
						{
							return -1;
						}

						const wind::json_object_t object = it->get_as_object();

						auto type_it = object.find("type");

						if (type_it == object.cend())
						{
							return -1;
						}

						if (type_it->get_type() != WIND::JSON::TYPE_STRING)
						{
							return -1;
						}

						type_s = type_it->get_as_string();
		
						auto file_it = object.find("file");

						if (file_it == object.cend())
						{
							return -1;
						}

						if (file_it->get_type() != WIND::JSON::TYPE_STRING)
						{
							return -1;
						}

						file_s = file_it->get_as_string();

						auto index_it = m_indexes.find(type_s);
						if (index_it == m_indexes.cend())
						{
							return -1;
						}
						int32_t index = index_it->second;

						dungeon::item::icon::name_map_t& map{ game_shared_data_t::get_dungeon_data()->get_icon_name_map((GAME::DUNGEON::ITEM::TYPE)index) };


						if (load(file_s, map) < 0)
						{
							return -1;
						}
					}

					return 0;
				}

				auto load_from_archive(const wind::string_t& archive_filename, const wind::string_t& filename) -> int32_t
				{
					wind::string_t filepath{ wind::path::make_canonical(archive_filename) };
					wind::string_t base{};
					wind::string_t ext{};
					wind::string_t path{};
					wind::json_t json{};
					bool archive = false;
					bool error = false;
					int32_t rv{ -1 };

					wind::path::split_filepath(filepath, path, base, ext);

					const PHYSFS_ArchiveInfo** i = nullptr;
					for (i = PHYSFS_supportedArchiveTypes(); *i != nullptr; i++)
					{
						if (wind::string::to_upper(ext) == (*i)->extension)
						{
							archive = true;
							break;
						}
					}

					if (archive)
					{
						const ALLEGRO::FILE_INTERFACE file_interface = al::get_new_file_interface();

						if (PHYSFS_mount(filename.c_str(), nullptr, 1))
						{
							al::physfs_addon::set_file_interface();
							rv = icon::load(filename);
							PHYSFS_unmount(filename.c_str());
						}

						al::set_new_file_interface(file_interface);
					}

					return rv;
				}
			}
		}
	}
}