module game;

import <cstdint>;
import <array>;
import <map>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item.base;
import :dungeon.item.color;

namespace game
{
	namespace dungeon
	{
		namespace item
		{
			namespace color
			{
				const std::array<const color_t, (size_t)GAME::DUNGEON::ITEM::COLOR::COUNT> m_array
				{ {
					{ "black", 0x12121d },
					{ "blue", 0x0000aa },
					{ "green", 0x00aa00 },
					{ "cyan", 0x00aaaa },
					{ "red", 0xaa0000 },
					{ "magenta", 0xaa00aa0 },
					{ "brown", 0xaa5500 },
					{ "light_gray", 0xaaaaaa },
					{ "dark_gray", 0x55555 },
					{ "light_blue", 0x5555ff },
					{ "light_green", 0x55ff55 },
					{ "light_cyan", 0x55ffff },
					{ "light_red", 0xff5555 },
					{ "light_magenta", 0xff55ff },
					{ "yellow", 0xffff55 },
					{ "white", 0xffffff }
				} };

				auto get_index(int32_t c) -> GAME::DUNGEON::ITEM::COLOR
				{
					static const char code[(size_t)GAME::DUNGEON::ITEM::COLOR::COUNT + 1] = "kbgcrmywKBGCRMYW";

					for (int32_t i = 0; i < (int32_t)GAME::DUNGEON::ITEM::COLOR::COUNT; ++i)
					{
						if (c == code[i])
						{
							return (GAME::DUNGEON::ITEM::COLOR)i;
						}
					}

					return GAME::DUNGEON::ITEM::COLOR::INVALID;
				}

				const color_t m_error{ "", 0};

				auto get_color(GAME::DUNGEON::ITEM::COLOR color) -> const color_t&
				{
					if (color > GAME::DUNGEON::ITEM::COLOR::INVALID && color < GAME::DUNGEON::ITEM::COLOR::COUNT)
					{
						return m_array[(size_t)color];
					}

					return m_error;
				}
			}
		}
	}
}