module game;

import <cstdint>;
import <vector>;
import <memory>;
import <map>;
import allegro;
import allegro.physfs_addon;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item.base;

namespace game
{
	namespace dungeon
	{
		item_data_t::item_data_t() : m_type(GAME::DUNGEON::ITEM::TYPE::INVALID), m_name("[ITEM]")
		{
		}

		item_data_t::~item_data_t()
		{
		}

		auto item_data_t::get_type() const->GAME::DUNGEON::ITEM::TYPE
		{
			return this->m_type;
		}

		auto item_data_t::set_type(GAME::DUNGEON::ITEM::TYPE type) -> void
		{
			this->m_type = type;
		}

		auto item_data_t::get_name() const -> const wind::string_t&
		{
			return this->m_name;
		}

		auto item_data_t::set_name(const wind::string_t& name) -> void
		{
			this->m_name = name;
		}

		auto item_data_t::get_cost() const->int32_t
		{
			return this->m_cost;
		}

		auto item_data_t::set_cost(int32_t cost) -> void
		{
			this->m_cost = cost;
		}

		auto item_data_t::get_icon() const->int32_t
		{
			return this->m_icon;
		}

		auto item_data_t::set_icon(int32_t icon) -> void
		{
			this->m_icon = icon;
		}

		auto item_data_t::get_weight() const->int32_t
		{
			return this->m_weight;
		}

		auto item_data_t::set_weight(int32_t weight) -> void
		{
			this->m_weight = weight;
		}
	}
}