module game;

import <cstdint>;
import <vector>;
import <memory>;
import <map>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item.base;
import :dungeon.item.armor;

namespace game
{
	namespace dungeon
	{
		namespace item
		{
			armor_t::armor_t()
			{
			}

			armor_t::~armor_t()
			{
			}

			auto armor_t::clone() const-> item_t
			{
				std::shared_ptr<armor_t> rv = std::make_shared<armor_t>();

				if (rv)
				{
					std::memcpy((void*)rv.get(), (void*)this, sizeof(armor_t));
				}

				return rv;
			}

			namespace armor
			{
				const std::map<wind::string_t, GAME::DUNGEON::ITEM::ARMOR::ICON> m_icons
				{ {
					  { "leather", GAME::DUNGEON::ITEM::ARMOR::ICON::LEATHER },
					  { "studded leather", GAME::DUNGEON::ITEM::ARMOR::ICON::STUDDED_LEATHER },
					  { "hide", GAME::DUNGEON::ITEM::ARMOR::ICON::HIDE },
					  { "ring mail", GAME::DUNGEON::ITEM::ARMOR::ICON::RING_MAIL },
					  { "chain mail", GAME::DUNGEON::ITEM::ARMOR::ICON::CHAIN_MAIL },
					  { "plate", GAME::DUNGEON::ITEM::ARMOR::ICON::PLATE },
					  { "shield", GAME::DUNGEON::ITEM::ARMOR::ICON::SHIELD }
				} };

				auto parser(const wind::json_object_t& json) -> item_t
				{
					return nullptr;
				}
			}
		}
	}
}