module game;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :dungeon.base;
import :dungeon.inventory.base;
import :dungeon.inventory.layout;

namespace game
{
	namespace dungeon
	{
		namespace inventory
		{
			layout_t::layout_t()
			{
			}

			layout_t::~layout_t()
			{
			}

			auto layout_t::get_screen_size() const -> const ALLEGRO::SIZE<int32_t>&
			{
				return this->m_screen_size;
			}

			auto layout_t::get_sara_position() const -> const ALLEGRO::POINT<int32_t>&
			{
				return this->m_sara_position;
			}

			auto layout_t::get_treasure_array() const -> const std::array<ALLEGRO::POINT<int32_t>, GAME::DUNGEON::INVENTORY::TREASURE::COUNT>&
			{
				return this->m_treasure_array;
			}

			auto layout_t::get_equipped_caption_position() const -> const ALLEGRO::POINT<int32_t>&
			{
				return this->m_equipped_caption_postion;
			}

			auto layout_t::get_slot_array() const -> const std::array<ALLEGRO::POINT<int32_t>, GAME::DUNGEON::INVENTORY::COUNT>
			{
				return this->m_slot_array;
			}

			auto layout_t::get_key_position() const -> const ALLEGRO::POINT<int32_t>&
			{
				return this->m_key_position;
			}

			auto layout_t::load_manifest(const wind::string_t& filename) -> int32_t
			{
				wind::json_t json{};

				wind::string_t fname{ GAME::MANIFESTS_DIRECTORY };
				fname += "\\" + filename;

				if (wind::json::load(json, fname) < 0)
				{
					return -1;
				}

				if (json.get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& object = json.get_as_object();

				auto inv_it = object.find("inventory");
				if (inv_it == object.cend())
				{
					return -1;
				}
				if (inv_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}
				const wind::json_object_t& inv_object = inv_it->get_as_object();

				///////////////////////////////

				auto size_it = inv_object.find("size");

				if (size_it == inv_object.cend())
				{
					return -1;
				}

				if (size_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& size_object = size_it->get_as_object();

				if (wind::json::parse_size<int32_t>(size_object, this->m_screen_size) < 0)
				{
					return -1;
				}

				///////////////////////////////

				auto sara_it = inv_object.find("sara");
				if (sara_it == inv_object.cend())
				{
					return -1;
				}
				if (sara_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& sara_object = sara_it->get_as_object();

				if (wind::json::parse_point<int32_t>(sara_object, this->m_sara_position) < 0)
				{
					return -1;
				}

				///////////////////////////////

				auto treasure_it = inv_object.find("treasure");

				if (treasure_it == inv_object.cend())
				{
					return -1;
				}

				if (treasure_it->get_type() != WIND::JSON::TYPE_ARRAY)
				{
					return -1;
				}

				const wind::json_array_t& treasure_array = treasure_it->get_as_array();

				if (treasure_array.size() != GAME::DUNGEON::INVENTORY::TREASURE::COUNT)
				{
					return -1;
				}

				int32_t index = 0;
				for (auto t = treasure_array.cbegin(); t != treasure_array.cend(); ++t)
				{
					if (t->get_type() != WIND::JSON::TYPE_OBJECT)
					{
						return -1;
					}

					const wind::json_object_t& t_object = t->get_as_object();


					if (wind::json::parse_point<int32_t>(t_object, this->m_treasure_array[index]) < 0)
					{
						return -1;
					}

					++index;
				}



				///////////////////////////////

				auto slot_it = inv_object.find("slot");
				if (slot_it == inv_object.cend())
				{
					return -1;
				}

				if (slot_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				ALLEGRO::POINT<int32_t> slot_position{};
				const wind::json_object_t& slot_object = slot_it->get_as_object();

				if (wind::json::parse_point<int32_t>(slot_object, slot_position) < 0)
				{
					return -1;
				}

				int32_t slot_index{ 0 };
				for (auto j = 0; j < GAME::DUNGEON::INVENTORY::SLOT::HEIGHT; ++j)
				{
					for (auto i = 0; i < GAME::DUNGEON::INVENTORY::SLOT::WIDTH; ++i)
					{
						this->m_slot_array[slot_index].x = slot_position.x + i * GAME::DUNGEON::INVENTORY::SLOT::SIZE.width;
						this->m_slot_array[slot_index].y = slot_position.y + j * GAME::DUNGEON::INVENTORY::SLOT::SIZE.height;


						++slot_index;
					}
				}


				///////////////////////////////

				auto equip_it = inv_object.find("equipped");
				if (equip_it == inv_object.cend())
				{
					return -1;
				}

				if (equip_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& equip_object = equip_it->get_as_object();


				auto equip_caption_it = equip_object.find("caption");
				if (equip_caption_it == equip_object.cend())
				{
					return -1;
				}

				if (equip_caption_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& equip_caption_object = equip_caption_it->get_as_object();

				if (wind::json::parse_point<int32_t>(equip_caption_object, this->m_equipped_caption_postion) < 0)
				{
					return -1;
				}

				auto equip_left_it = equip_object.find("left");
				if (equip_left_it == equip_object.cend())
				{
					return -1;
				}

				if (equip_left_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& equip_left_object = equip_left_it->get_as_object();

				if (wind::json::parse_point<int32_t>(equip_left_object, this->m_slot_array[GAME::DUNGEON::INVENTORY::SLOT::COUNT + std::to_underlying(GAME::DUNGEON::INVENTORY::EQUIPPED::LEFT)]) < 0)
				{
					return -1;
				}

				auto equip_right_it = equip_object.find("right");
				if (equip_right_it == equip_object.cend())
				{
					return -1;
				}

				if (equip_right_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& equip_right_object = equip_right_it->get_as_object();

				if (wind::json::parse_point<int32_t>(equip_right_object, this->m_slot_array[GAME::DUNGEON::INVENTORY::SLOT::COUNT + std::to_underlying(GAME::DUNGEON::INVENTORY::EQUIPPED::RIGHT)]) < 0)
				{
					return -1;
				}

				auto equip_body_it = equip_object.find("body");
				if (equip_body_it == equip_object.cend())
				{
					return -1;
				}

				if (equip_body_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& equip_body_object = equip_body_it->get_as_object();

				if (wind::json::parse_point<int32_t>(equip_body_object, this->m_slot_array[GAME::DUNGEON::INVENTORY::SLOT::COUNT + std::to_underlying(GAME::DUNGEON::INVENTORY::EQUIPPED::BODY)]) < 0)
				{
					return -1;
				}

				///////////////////////////////

				auto trash_it = inv_object.find("trash");
				if (trash_it == inv_object.cend())
				{
					return -1;
				}
				if (trash_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& trash_object = trash_it->get_as_object();

				if (wind::json::parse_point<int32_t>(trash_object, this->m_slot_array[GAME::DUNGEON::INVENTORY::TRASH]) < 0)
				{
					return -1;
				}

				///////////////////////////////

				auto key_it = inv_object.find("key");
				if (key_it == inv_object.cend())
				{
					return -1;
				}
				if (key_it->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& key_object = key_it->get_as_object();

				if (wind::json::parse_point<int32_t>(key_object, this->m_key_position) < 0)
				{
					return -1;
				}

				return 0;
			}
		}
	}
}
