module game;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :dungeon.base;
import :dungeon.item;
import :dungeon.inventory.base;
import :dungeon.inventory.layout;
import :dungeon.player;

namespace GAME
{
	namespace DUNGEON
	{
		namespace INVENTORY
		{
			namespace SLOT
			{
				namespace STATUS
				{
					static constexpr int32_t NORMAL = 0;
					static constexpr int32_t HOVER = 1;
					static constexpr int32_t DOUBLE = 2;
				}
			}
		}
	}
}

namespace game
{
	namespace dungeon
	{
		namespace inventory
		{
			static auto get_bitmap_region(const ALLEGRO::POINT<int32_t>& point, bool item, bool double_equipped, ALLEGRO::RECTANGLE<int32_t>& region) -> void
			{
				region = { {0, 0}, GAME::DUNGEON::INVENTORY::SLOT::SIZE };

				if (item)
				{
					if (double_equipped)
					{
						region.position.y = GAME::DUNGEON::INVENTORY::SLOT::SIZE.height;
					}
					else
					{
						region.position.x += GAME::DUNGEON::INVENTORY::SLOT::SIZE.width;
					}
				}
			}

			auto draw(const ALLEGRO::SIZE<size_t>& viewport, const player::data_t& data, const layout_t& layout, int32_t& inhand) -> void
			{
				static const ALLEGRO::POINT<float>& mouse = game::game_shared_data_t::get_mouse();

				auto items = data->get_items();

				///////////////////////////////////
				// draw background ////////////////
				///////////////////////////////////

				ALLEGRO::BITMAP background = std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game::game_shared_data_t::get_datafile()[GAME::DATAFILE::SHARED_BACKGROUND]);
				wind::bitmap::flood_fill(background, { { 0,0 }, viewport });

				///////////////////////////////////
				// draw sara ///// ////////////////
				///////////////////////////////////

				ALLEGRO::BITMAP sara{ std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game::game_shared_data_t::get_datafile()[GAME::DATAFILE::INVENTORY_SARA]) };
				al::draw_bitmap(sara, layout.get_sara_position());

				///////////////////////////////////
				// equipped caption ///////////////
				///////////////////////////////////

				ALLEGRO::BITMAP equipped{ std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game::game_shared_data_t::get_datafile()[GAME::DATAFILE::INVENTORY_EQUIPPED]) };
				al::draw_bitmap(equipped, layout.get_equipped_caption_position());

				///////////////////////////////////
				// draw slots ///// ////////////////
				///////////////////////////////////

				int32_t slot_index = 0;
				auto slot_array = layout.get_slot_array();
				int32_t slot_status = 0;
				bool double_equipped = false;
				ALLEGRO::RECTANGLE<int32_t> slot_bitmap_region = { {0,0}, GAME::DUNGEON::INVENTORY::SLOT::SIZE };
				ALLEGRO::RECTANGLE<int32_t> actual_region = { {0,0}, GAME::DUNGEON::INVENTORY::SLOT::SIZE };

				ALLEGRO::BITMAP slot_bitmap{ std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game::game_shared_data_t::get_datafile()[GAME::DATAFILE::INVENTORY_SLOT]) };

				for (auto slot = slot_array.cbegin(); slot != slot_array.cend(); ++slot, ++slot_index)
				{
					actual_region.position = (*slot);

					double_equipped = false;
					if (slot_index == GAME::DUNGEON::INVENTORY::SLOT::COUNT &&
						items[slot_index] && items[slot_index] == items[slot_index + 1])
					{
						double_equipped = true;
					}

					get_bitmap_region((*slot), (bool)items[slot_index], double_equipped, slot_bitmap_region);

					al::draw_bitmap_region(slot_bitmap, slot_bitmap_region, actual_region.position);

					if (actual_region.is_inside(mouse))
					{
						slot_bitmap_region.position.x = 2 * GAME::DUNGEON::INVENTORY::SLOT::SIZE.width;
						al::draw_bitmap_region(slot_bitmap, slot_bitmap_region, actual_region.position);
					}

					if (items[slot_index])
					{
						int32_t icon_index = items[slot_index]->get_icon();

						ALLEGRO::ASSERT(icon_index >= 0);

						const ALLEGRO::BITMAP& bitmap{ dungeon::item::icon::get_bitmap(items[slot_index]->get_type(), icon_index + 1) };

						ALLEGRO::ASSERT(bitmap);

						ALLEGRO::SIZE<size_t> icon_size{ al::get_bitmap_dimensions(bitmap) };
						ALLEGRO::POINT<int32_t> icon_position{ actual_region.position.x + ((GAME::DUNGEON::INVENTORY::SLOT::SIZE.width - icon_size.width) >> 1), actual_region.position.y + ((GAME::DUNGEON::INVENTORY::SLOT::SIZE.height - icon_size.height) >> 1) };
						ALLEGRO::COLOR color = wind::map_rgba_i(0xffffffff);

						if (inhand == slot_index)
						{
							color.alpha = 0.4f;
						}

						al::draw_tinted_bitmap(bitmap, color, icon_position);
					}
					else
					{
						if (slot_index >= GAME::DUNGEON::INVENTORY::SLOT::COUNT)
						{
							ALLEGRO::RECTANGLE<int32_t> emboss_region{
								{(3 + slot_index - GAME::DUNGEON::INVENTORY::SLOT::COUNT) * GAME::DUNGEON::INVENTORY::SLOT::SIZE.width, 0 },
								GAME::DUNGEON::INVENTORY::SLOT::SIZE };

							al::draw_bitmap_region(slot_bitmap, emboss_region, actual_region.position);
						}
					}
				}

				///////////////////////////////////
				// draw key ///// ////////////////
				///////////////////////////////////

				ALLEGRO::BITMAP key_bitmap{ std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game::game_shared_data_t::get_datafile()[GAME::DATAFILE::INVENTORY_KEY]) };
				ALLEGRO::RECTANGLE<int32_t> key_region{ {0, 0}, GAME::DUNGEON::TILE::SIZE };
				if (data->get_key())
				{
					al::draw_bitmap_region(key_bitmap, key_region, layout.get_key_position());
				}
				key_region.position.x += GAME::DUNGEON::TILE::SIZE.width;
				al::draw_bitmap_region(key_bitmap, key_region, layout.get_key_position());


				///////////////////////////////////
				// draw treasures ///// ////////////////
				///////////////////////////////////

				ALLEGRO::BITMAP icon_bitmap{ std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game::game_shared_data_t::get_datafile()[GAME::DATAFILE::INVENTORY_ICONS]) };
				auto array = layout.get_treasure_array();
				ALLEGRO::RECTANGLE<int32_t> icon_region{ {0, 0}, GAME::DUNGEON::INVENTORY::TREASURE::SIZE };
				int32_t icon_index = 0;
				for (auto ait = array.cbegin(); ait != array.cend(); ++ait)
				{
					icon_region.position.x = icon_index * GAME::DUNGEON::INVENTORY::TREASURE::SIZE.width;
					al::draw_bitmap_region(icon_bitmap, icon_region, (*ait));
					++icon_index;
				}

				if (inhand >= 0)
				{
					const item_t& slot = items[inhand];
					int32_t icon_index = slot->get_icon();
					if (icon_index >= 0)
					{
						const ALLEGRO::BITMAP& bitmap{ dungeon::item::icon::get_bitmap(slot->get_type(), icon_index + 1) };
						if (bitmap)
						{
							ALLEGRO::SIZE<size_t> icon_size{ al::get_bitmap_dimensions(bitmap) };
							ALLEGRO::POINT<int32_t> icon_position{ mouse.x - ((icon_size.width) >> 1), mouse.y - ((icon_size.height) >> 1) };
							al::draw_bitmap(bitmap, icon_position);
						}
					}
				}
			}
		}
	}
}
