module game;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :dungeon.base;
import :dungeon.inventory.base;
import :dungeon.inventory.layout;
import :dungeon.player.data;

namespace game
{
	namespace dungeon
	{
		namespace inventory
		{
			auto draw(const ALLEGRO::SIZE<size_t>& viewport, const player::data_t& data, const layout_t& layout, int32_t& inhand) -> void;
		}

		inventory_t::inventory_t()
		{
		}

		inventory_t::~inventory_t()
		{
		}

		auto inventory_t::on_initialize() -> int32_t
		{
			if (this->m_layout.load_manifest(GAME::DUNGEON::INVENTORY::LAYOUT::MANIFEST_FILE) < 0)
			{
				return -1;
			}

			return 0;
		}

		auto inventory_t::on_shutdown() -> void
		{
		}

		auto inventory_t::on_update() -> GAME::DUNGEON::STATE
		{
			int32_t mouse_inside{ -1 };

			if (wind::input::keyboard::was_pressed(ALLEGRO::KEY_ESCAPE))
			{
				this->m_inhand = -1;
				wind::input::keyboard::acknowledge(ALLEGRO::KEY_ESCAPE);
				return GAME::DUNGEON::STATE::INPUT;
			}

			const ALLEGRO::POINT<float>& mouse = game::game_shared_data_t::get_mouse();

			ALLEGRO::RECTANGLE<float> region{ {0,0}, GAME::DUNGEON::INVENTORY::SLOT::SIZE };
			auto slot_array = this->m_layout.get_slot_array();

			int32_t slot_index = 0;
			for (auto slot : slot_array)
			{
				region.position = slot;

				if (region.is_inside(mouse))
				{
					mouse_inside = slot_index;
					break;
				}

				++slot_index;
			}

			if (wind::input::mouse::is_pressed(ALLEGRO::MOUSE_BUTTON_LEFT))
			{
				if (wind::input::mouse::was_pressed(ALLEGRO::MOUSE_BUTTON_LEFT))
				{
					if (mouse_inside >= 0)
					{
						this->do_mouse_down(mouse_inside);
					}
				}
				wind::input::mouse::acknowledge(ALLEGRO::MOUSE_BUTTON_LEFT);
			}
			else
			{
				if (wind::input::mouse::was_released(ALLEGRO::MOUSE_BUTTON_LEFT))
				{
					if (mouse_inside >= 0)
					{
						this->do_mouse_up(mouse_inside);
					}
					else
					{
						this->m_inhand = -1;
					}
					wind::input::mouse::acknowledge(ALLEGRO::MOUSE_BUTTON_LEFT);
				}
			}

			return GAME::DUNGEON::STATE::INVENTORY;
		}

		auto inventory_t::on_render() -> void
		{
			dungeon::inventory::draw(this->get_viewport(), this->m_data, this->m_layout, this->m_inhand);
		}

		auto inventory_t::get_viewport() -> ALLEGRO::SIZE<int32_t>
		{
			return this->m_layout.get_screen_size();
		}

		auto inventory_t::get_data() const -> const player::data_t&
		{
			return this->m_data;
		}

		auto inventory_t::set_data(const player::data_t& data) -> void
		{
			this->m_data = data;
		}

		auto inventory_t::do_mouse_down(int32_t slot_index) -> void
		{
			if (this->m_inhand < 0)
			{
				if (this->m_data->get_items()[slot_index])
				{
					this->m_inhand = slot_index;
				}
				else
				{
				}
			}
		}

		auto inventory_t::do_mouse_up(int32_t slot_index) -> void
		{
			auto items = this->m_data->get_items();

			if (this->m_inhand >= 0)
			{
				if (this->m_inhand != slot_index && !items[slot_index])
				{
					items[slot_index] = items[this->m_inhand];
					items[m_inhand].reset();
				}
			}

			this->m_inhand = -1;
		}
	}
}