module game;

import <cstdint>;
import <vector>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.dice;

namespace game
{
	namespace dungeon
	{
		namespace dice
		{
			auto roll(int32_t count, int32_t sides) -> int32_t
			{
				int32_t total{ 0 };

				for (int32_t i = 0; i < count; ++i)
				{
					total += (wind::random::generate(1000) % sides);
				}

				return total;
			}

			auto roll(const dice_t& dice) -> int32_t
			{
				return roll(dice.m_count, dice.m_sides);
			}
		}
	}
}