module game;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :dungeon.base;

namespace game
{
	namespace dungeon
	{
		auto get_delta(GAME::DIRECTION direction) -> ALLEGRO::POINT<int32_t>
		{
			ALLEGRO::POINT<int32_t> delta{ 0, 0 };

			switch (direction)
			{
			case GAME::DIRECTION::NORTH:
			{
				delta.y = -1;
			} break;
			case GAME::DIRECTION::SOUTH:
			{
				delta.y = 1;
			} break;
			case GAME::DIRECTION::EAST:
			{
				delta.x = 1;
			} break;
			case GAME::DIRECTION::WEST:
			{
				delta.x = -1;
			} break;
			}

			return delta;
		}
	}
}