module game;

import <cstdint>;
import <vector>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item;
import :dungeon.bag;

namespace game
{
	namespace dungeon
	{
		bag_tag_t::bag_tag_t() : m_data()
		{
		}

		bag_tag_t::bag_tag_t(size_t size) : m_data(size)
		{
		}

		bag_tag_t::~bag_tag_t()
		{
		}

		auto bag_tag_t::clear() -> void
		{
			this->m_data.clear();
		}

		auto bag_tag_t::data() -> void*
		{
			return this->m_data.get_data();
		}

		auto bag_tag_t::data() const -> const void*
		{
			return this->m_data.get_data();
		}

		auto bag_tag_t::size() const -> size_t
		{
			return this->m_data.get_count();
		}

		auto bag_tag_t::at(size_t index) -> bag_tag_t::reference_element_type
		{
			ALLEGRO::ASSERT(index < this->m_data.get_count());
			return this->m_data[index];
		}

		auto bag_tag_t::at(size_t index) const -> bag_tag_t::const_reference_element_type
		{
			ALLEGRO::ASSERT(index < this->m_data.get_count());
			return this->m_data[index];
		}

		auto bag_tag_t::operator [](size_t index) -> bag_tag_t::reference_element_type
		{
			ALLEGRO::ASSERT(index < this->m_data.get_count());
			return this->m_data[index];
		}

		auto bag_tag_t::operator [](size_t index) const -> bag_tag_t::const_reference_element_type
		{
			ALLEGRO::ASSERT(index < this->m_data.get_count());
			return this->m_data[index];
		}

		auto bag_tag_t::begin() -> bag_tag_t::iterator
		{
			return iterator(this->m_data, 0);
		}

		auto bag_tag_t::end() -> bag_tag_t::iterator
		{
			return iterator(this->m_data, this->m_data.get_count() - 1);
		}

		auto bag_tag_t::cbegin() const -> bag_tag_t::const_iterator
		{
			return const_iterator(this->m_data, 0);
		}

		auto bag_tag_t::cend() const -> bag_tag_t::const_iterator
		{
			return const_iterator(this->m_data, this->m_data.get_count() - 1);
		}
	}
}
