module game;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :boardgame.player;
import :math;

namespace game
{
	namespace boardgame
	{
		player_t::player_t()
		{
		}

		player_t::~player_t()
		{
		}

		auto player_t::on_update() -> int32_t
		{
			switch (this->m_state)
			{
			case GAME::BOARDGAME::PLAYER::STATE::IDLE:
			{
				if (this->m_moves > 0)
				{
					this->m_state = GAME::BOARDGAME::PLAYER::STATE::MARKING;
				}
			} break;
			case GAME::BOARDGAME::PLAYER::STATE::MARKING:
			{
				if (this->m_moves > 0)
				{
					++this->m_next_marker;
					--this->m_moves;

					this->m_facing = wind::math::atan2(this->m_position.y - this->m_path[this->m_next_marker].y, this->m_path[this->m_next_marker].x - this->m_position.x);
					this->m_state = GAME::BOARDGAME::PLAYER::STATE::WALKING;
				}
				else
				{
					this->m_state = GAME::BOARDGAME::PLAYER::STATE::IDLE;
				}
			}

			case GAME::BOARDGAME::PLAYER::STATE::WALKING:
			{
				static bool x{ false };
				static bool y{ false };
				ALLEGRO::POINT<float> diff{ this->m_path[this->m_next_marker] - this->m_position };

				if (!x)
				{
					if (wind::math::abs(diff.x) < 0.5f)
					{
						x = true;
						this->m_position.x = this->m_path[this->m_next_marker].x;
					}
					else
					{
						this->m_position.x += wind::math::cos(this->m_facing);
					}
				}

				if (!y)
				{
					if (wind::math::abs(diff.y) < 0.5f)
					{
						y = true;
						this->m_position.y = this->m_path[this->m_next_marker].y;
					}
					else
					{
						this->m_position.y -= wind::math::sin(this->m_facing);
					}
				}
				if (x && y)
				{
					x = y = false;
					this->m_state = GAME::BOARDGAME::PLAYER::STATE::STOPPED;
					this->m_current_marker = this->m_next_marker;
					if (this->m_next_marker == this->m_path.get_count() - 1)
					{
						this->m_state = GAME::BOARDGAME::PLAYER::STATE::WON;
						this->m_moves = 0;
					}
				}
			} break;
			case GAME::BOARDGAME::PLAYER::STATE::STOPPED:
			{
				if (this->m_moves > 0)
				{
					this->m_state = GAME::BOARDGAME::PLAYER::STATE::MARKING;
				}
				else
				{
					this->m_state = GAME::BOARDGAME::PLAYER::STATE::IDLE;
				}
			} break;
			case GAME::BOARDGAME::PLAYER::STATE::WON:
			{
			} break;
			}

			return 0;
		}

		auto player_t::on_render() -> void
		{
			ALLEGRO::POINT<float> tpos = { (float)(this->m_frame << GAME::BOARDGAME::TILE::SHIFT.x), (float)((int32_t)game::math::facing(this->m_facing) << GAME::BOARDGAME::TILE::SHIFT.y) };


			switch (this->m_state)
			{
			case GAME::BOARDGAME::PLAYER::STATE::RECOVERY:
			{
				ALLEGRO::COLOR tint{ 1.0f, 1.0f, 1.0f, 1.0f };
				tint.red = tint.green = tint.blue = tint.alpha = 0.05f + ((float)wind::random::generate(1000)) * 0.0005f;

				al::draw_tinted_bitmap_region(this->m_bitmap, tint, { tpos, {GAME::BOARDGAME::TILE::SIZE.width, GAME::BOARDGAME::TILE::SIZE.height} }, this->m_position + GAME::BOARDGAME::PLAYER::DELTA);
			} break;
			case GAME::BOARDGAME::PLAYER::STATE::HURTING:
			{
				ALLEGRO::COLOR tint{ 1.0f, 0.0f, 0.0f, 0.0f };

				al::draw_tinted_bitmap_region(this->m_bitmap, tint, { tpos, {GAME::BOARDGAME::TILE::SIZE.width, GAME::BOARDGAME::TILE::SIZE.height} }, this->m_position + GAME::BOARDGAME::PLAYER::DELTA);
				tint.green = tint.blue = tint.alpha = 0.05f + ((float)wind::random::generate(1000)) * 0.0005f;

				al::draw_tinted_bitmap_region(this->m_bitmap, tint, { tpos, {GAME::BOARDGAME::TILE::SIZE.width, GAME::BOARDGAME::TILE::SIZE.height} }, this->m_position + GAME::BOARDGAME::PLAYER::DELTA);
			} break;
			default:
			{
				al::draw_bitmap_region(this->m_bitmap, { tpos, {GAME::BOARDGAME::TILE::SIZE.width, GAME::BOARDGAME::TILE::SIZE.height} }, this->m_position + GAME::BOARDGAME::PLAYER::DELTA);
			} break;
			}
		}

		auto player_t::set_path(const wind::array_t<ALLEGRO::POINT<float>>& path) -> void
		{
			this->m_path = path;
		}

		auto player_t::get_bitmap() const -> const ALLEGRO::BITMAP&
		{
			return this->m_bitmap;
		}

		auto player_t::set_bitmap(const ALLEGRO::BITMAP& bitmap) -> void
		{
			this->m_bitmap = bitmap;
		}

		auto player_t::get_position() const->const ALLEGRO::POINT<float>&
		{
			return this->m_position;
		}

		auto player_t::set_position(const ALLEGRO::POINT<float>& position) -> void
		{
			this->m_position = position;
		}

		auto player_t::get_frame() -> int32_t
		{
			return this->m_frame;
		}

		auto player_t::set_frame(int32_t frame) -> void
		{
			this->m_frame = frame;
		}

		auto player_t::get_facing() -> float
		{
			return this->m_facing;
		}

		auto player_t::set_facing(float radians) -> void
		{
			this->m_facing = radians;
		}

		auto player_t::get_current_marker() -> int32_t
		{
			return this->m_current_marker;
		}

		auto player_t::set_current_marker(int32_t marker) -> void
		{
			this->m_current_marker = marker;
		}

		auto player_t::get_next_marker() -> int32_t
		{
			return this->m_next_marker;
		}

		auto player_t::set_next_marker(int32_t marker) -> void
		{
			this->m_next_marker = marker;
		}

		auto player_t::get_moves() -> int32_t
		{
			return this->m_moves;
		}

		auto player_t::set_moves(int32_t moves) -> void
		{
			this->m_moves = moves;
		}

		auto player_t::get_dice() -> int32_t
		{
			return this->m_dice;
		}

		auto player_t::set_dice(int32_t dice) -> void
		{
			this->m_dice = dice;
		}

		auto player_t::get_state() const->GAME::BOARDGAME::PLAYER::STATE
		{
			return this->m_state;
		}

		auto player_t::set_state(GAME::BOARDGAME::PLAYER::STATE state) -> void
		{
			this->m_state = state;
		}
	}
}