module game;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :boardgame.mob;

namespace game
{
	namespace boardgame
	{
		mob_t::mob_t()
		{
		}

		mob_t::~mob_t()
		{
		}

		auto mob_t::on_update() -> int32_t
		{
			return 0;
		}

		auto mob_t::on_render() -> void
		{
			ALLEGRO::SIZE<size_t> size = al::get_bitmap_dimensions(this->m_bitmap);
			al::draw_bitmap(this->m_bitmap, { this->m_position.x - (int32_t)(size.width >> 1), this->m_position.y - (int32_t)(size.height >> 1) - 8 });
		}

		auto mob_t::follow(const ALLEGRO::POINT<float>& point)
		{
			this->m_follow = point;
		}

		auto mob_t::get_bitmap() const -> const ALLEGRO::BITMAP&
		{
			return this->m_bitmap;
		}

		auto mob_t::set_bitmap(const ALLEGRO::BITMAP& bitmap) -> void
		{
			this->m_bitmap = bitmap;
		}

		auto mob_t::get_marker() -> int32_t
		{
			return this->m_marker;
		}

		auto mob_t::set_marker(int32_t marker) -> void
		{
			this->m_marker = marker;
		}

		auto mob_t::get_position() const->const ALLEGRO::POINT<float>&
		{
			return this->m_position;
		}

		auto mob_t::set_position(const ALLEGRO::POINT<float>& position) -> void
		{
			this->m_position = position;
		}

		auto mob_t::get_type() const->GAME::BOARDGAME::MOB::TYPE
		{
			return this->m_type;
		}

		auto mob_t::set_type(GAME::BOARDGAME::MOB::TYPE type) -> void
		{
			this->m_type = type;
		}

		auto mob_t::get_state() const->GAME::BOARDGAME::MOB::STATE
		{
			return this->m_state;
		}

		auto mob_t::set_state(GAME::BOARDGAME::MOB::STATE state) -> void
		{
			this->m_state = state;
		}
	}
}