module;

#define OUTPUT_BITMAP_03

module game;

import <cstdint>;
import <memory>;
import allegro;
import allegro.primitives_addon;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :boardgame;
import :boardgame.base;
import :boardgame.mob;
import :boardgame.player;
import :boardgame.treasure;

namespace game
{
	namespace boardgame
	{
		using ostruct_t = struct ostruct_tag_t
		{
			int32_t m_bitmap_index{ -1 };
			GAME::BOARDGAME::ITEM_TYPE m_item_type{ -1 };
			int32_t m_marker{ -1 };
			int32_t m_order;
			int32_t m_sub_type{ -1 };
		};
		auto build_background(ALLEGRO::BITMAP& background,
			std::array<boardgame::mob_t, (size_t)GAME::BOARDGAME::MOB::TYPE::COUNT>& mobs,
			std::array<boardgame::treasure_t, (size_t)GAME::BOARDGAME::TREASURE::TYPE::COUNT>& treasures,
			const wind::array_t<ALLEGRO::POINT<float>>& path) -> int32_t
		{
			std::map<wind::string_t, boardgame::ostruct_t> names{};

			names["krampus"] = { GAME::DATAFILE::BOARDGAME_TITLE_KRAMPUS, GAME::BOARDGAME::ITEM_TYPE::BACKGROUND, -1, -1 };
			names["hack"] = { GAME::DATAFILE::BOARDGAME_TITLE_HACK, GAME::BOARDGAME::ITEM_TYPE::BACKGROUND, -1, -1 };
			names["boardgame"] = { GAME::DATAFILE::BOARDGAME_TITLE_BOARDGAME, GAME::BOARDGAME::ITEM_TYPE::BACKGROUND, -1, -1 };
			names["dragon"] = { GAME::DATAFILE::BOARDGAME_DRAGON, GAME::BOARDGAME::ITEM_TYPE::MOB, 0, (int32_t)GAME::BOARDGAME::MOB::TYPE::DRAGON };
			names["demon"] = { GAME::DATAFILE::BOARDGAME_DEMON, GAME::BOARDGAME::ITEM_TYPE::MOB, 1, (int32_t)GAME::BOARDGAME::MOB::TYPE::DEMON };
			names["ogre"] = { GAME::DATAFILE::BOARDGAME_OGRE, GAME::BOARDGAME::ITEM_TYPE::MOB, 2, (int32_t)GAME::BOARDGAME::MOB::TYPE::OGRE };
			names["treasure_gift"] = { GAME::DATAFILE::BOARDGAME_TREASURE_00, GAME::BOARDGAME::ITEM_TYPE::TREASURE, 1, (int32_t)GAME::BOARDGAME::TREASURE::TYPE::GIFT };
			names["treasure_santa"] = { GAME::DATAFILE::BOARDGAME_TREASURE_01, GAME::BOARDGAME::ITEM_TYPE::TREASURE, 2, (int32_t)GAME::BOARDGAME::TREASURE::TYPE::SANTA };
			names["treasure_tree"] = { GAME::DATAFILE::BOARDGAME_TREASURE_02, GAME::BOARDGAME::ITEM_TYPE::TREASURE, 3, (int32_t)GAME::BOARDGAME::TREASURE::TYPE::TREE };
			names["treasure_chest"] = { GAME::DATAFILE::BOARDGAME_TREASURE_03, GAME::BOARDGAME::ITEM_TYPE::TREASURE, 4, (int32_t)GAME::BOARDGAME::TREASURE::TYPE::CHEST };
			names["treasure_deer"] = { GAME::DATAFILE::BOARDGAME_TREASURE_04, GAME::BOARDGAME::ITEM_TYPE::TREASURE, 5, (int32_t)GAME::BOARDGAME::TREASURE::TYPE::DEER };
			names["present"] = { GAME::DATAFILE::BOARDGAME_PRESENT, GAME::BOARDGAME::ITEM_TYPE::TREASURE, 0, (int32_t)GAME::BOARDGAME::TREASURE::TYPE::PRESENT };
			names["start"] = { GAME::DATAFILE::BOARDGAME_START, GAME::BOARDGAME::ITEM_TYPE::BACKGROUND, -1, -1 };

			wind::json_t json{};

			wind::string_t filename(GAME::MANIFESTS_DIRECTORY);
			
			filename += "\\" + wind::string_t(GAME::BOARDGAME::PLACEMENT_FILENAME);

			if (wind::json::load(json, filename) < 0)
			{
				return -1;
			}

			if (json.get_type() != WIND::JSON::TYPE_OBJECT)
			{
				return -1;
			}

			const wind::json_object_t& object = json.get_as_object();

			wind::json_object_t::const_iterator it = object.find("coordinates");
			if (it == object.cend())
			{
				return -1;
			}

			if (it->get_type() != WIND::JSON::TYPE_ARRAY)
			{
				return -1;
			}

			const wind::json_array_t& array{ it->get_as_array() };
			wind::array_t<std::pair<wind::string_t, ALLEGRO::POINT<int32_t>>> coordinates{ array.size() };
			size_t index{ 0 };
			ALLEGRO::POINT<int32_t> position{ 0, 0 };
			wind::string_t name{};

			for (auto ait = array.cbegin(); ait != array.cend(); ++ait)
			{
				if (ait->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& cobject = ait->get_as_object();

				wind::json_object_t::const_iterator n = cobject.find("name");
				if (n == cobject.cend())
				{
					return -1;
				}
				name = n->get_as_string();

				wind::json_object_t::const_iterator t = cobject.find("type");
				if (t == cobject.cend())
				{
					return -1;
				}

				wind::string_t type = t->get_as_string();

				if (type == "title")
				{
					wind::json_object_t::const_iterator x = cobject.find("x");
					if (x == cobject.cend())
					{
						return -1;
					}
					position.x = x->get_as_number();

					wind::json_object_t::const_iterator y = cobject.find("y");
					if (y == cobject.cend())
					{
						return -1;
					}
					position.y = y->get_as_number();
				}
				else
				{
					if (type == "mob" || type == "item")
					{
						wind::json_object_t::const_iterator m = cobject.find("marker");
						if (m == cobject.cend())
						{
							return -1;
						}
						int32_t marker = m->get_as_number();

						if (marker < 0 || marker >= path.get_count())
						{
							return -1;
						}

						names[name].m_marker = marker;

						position = path[marker];
					}
					else
					{
						return -1;
					}
				}

				coordinates[index].first = name;
				coordinates[index].second = position;
				++index;
			}

			ALLEGRO::BITMAP bg = std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game_shared_data_t::get_datafile()[GAME::DATAFILE::SHARED_BACKGROUND]);
			ALLEGRO::BITMAP overlay = std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game_shared_data_t::get_datafile()[GAME::DATAFILE::BOARDGAME_OVERLAY]);
			ALLEGRO::SIZE<size_t> size = al::get_bitmap_dimensions(overlay);
			ALLEGRO::SIZE<size_t> bgsize = al::get_bitmap_dimensions(bg);

			background = al::create_bitmap(size);
			if (!background)
			{
				return -1;
			}

			ALLEGRO::BITMAP target = al::get_target_bitmap();
			al::set_target_bitmap(background);

			for (position.y = 0; position.y <= size.height; position.y += (int32_t)bgsize.height)
			{
				for (position.x = 0; position.x <= size.width; position.x += (int32_t)bgsize.width)
				{
					al::draw_bitmap(bg, position);
				}
			}
			al::draw_bitmap(overlay, { 0, 0 });

			for (auto a = coordinates.cbegin(); a != coordinates.cend(); ++a)
			{
				const std::pair<wind::string_t, ALLEGRO::POINT<int32_t>>& p = (*a);

				auto t = names.find(p.first);
				if (t == names.cend())
				{
					return -1;
				}

				boardgame::ostruct_t& s = (*t).second;

				ALLEGRO::BITMAP bitmap = std::static_pointer_cast<ALLEGRO::BITMAP_DATA>(game_shared_data_t::get_datafile()[(*t).second.m_bitmap_index]);

				switch (s.m_item_type)
				{
				case GAME::BOARDGAME::ITEM_TYPE::MOB:
				{
					boardgame::mob_t& mob = mobs[s.m_order];

					mob.set_bitmap(bitmap);
					mob.set_position(p.second);
					mob.set_marker(s.m_marker);
					mob.set_type((GAME::BOARDGAME::MOB::TYPE)s.m_sub_type);
					mob.set_state(GAME::BOARDGAME::MOB::STATE::IDLE);
				} break;
				case GAME::BOARDGAME::ITEM_TYPE::TREASURE:
				{
					boardgame::treasure_t& treasure = treasures[s.m_order];

					treasure.set_bitmap(bitmap);
					treasure.set_position(p.second);
					treasure.set_marker(s.m_marker);
					treasure.set_type((GAME::BOARDGAME::TREASURE::TYPE)s.m_sub_type);
					treasure.set_state(GAME::BOARDGAME::TREASURE::STATE::IDLE);
				} break;
				case GAME::BOARDGAME::ITEM_TYPE::BACKGROUND:
				{
					al::draw_bitmap(bitmap, p.second);
				} break;
				}
			}

			ALLEGRO::POINT<int32_t> pos2 = GAME::BOARDGAME::DICE::FRAME::POSITION;
			pos2.x += GAME::BOARDGAME::DICE::FRAME::SIZE.width - 1;
			pos2.y += GAME::BOARDGAME::DICE::FRAME::SIZE.height - 1;
			al::draw_filled_rectangle(GAME::BOARDGAME::DICE::FRAME::POSITION, pos2, wind::map_rgb_i(GAME::BOARDGAME::PALETTE::LIGHT));
			al::draw_rectangle(GAME::BOARDGAME::DICE::FRAME::POSITION, pos2, wind::map_rgb_i(GAME::BOARDGAME::PALETTE::DARK), 1.0f);

#ifdef OUTPUT_BITMAP
			for (auto m : mobs)
			{
				m.on_render();
			}

			for (auto t : treasures)
			{
				t.on_render();
			}
#endif

			al::set_target_bitmap(target);

#ifdef OUTPUT_BITMAP
			al::save_bitmap("assets\\temp.png", background);
#endif

			return 0;
		}

		auto build_path(wind::array_t<ALLEGRO::POINT<float>>& path) -> int32_t
		{
			wind::json_t json{};
			wind::string_t filename(GAME::MANIFESTS_DIRECTORY);

			filename += "\\" + wind::string_t(GAME::BOARDGAME::PATH_FILENAME);

			if (wind::json::load(json, filename) < 0)
			{
				return -1;
			}

			if (json.get_type() != WIND::JSON::TYPE_OBJECT)
			{
				return -1;
			}

			const wind::json_object_t& object = json.get_as_object();

			wind::json_object_t::const_iterator it = object.find("coordinates");
			if (it == object.cend())
			{
				return -1;
			}

			if (it->get_type() != WIND::JSON::TYPE_ARRAY)
			{
				return -1;
			}

			const wind::json_array_t& array{ it->get_as_array() };
			size_t index{ 0 };

			path = wind::array_t<ALLEGRO::POINT<float>>(array.size());

			for (auto ait = array.cbegin(); ait != array.cend(); ++ait)
			{
				if (ait->get_type() != WIND::JSON::TYPE_OBJECT)
				{
					return -1;
				}

				const wind::json_object_t& cobject = ait->get_as_object();

				wind::json_object_t::const_iterator x = cobject.find("x");
				if (x == cobject.cend())
				{
					return -1;
				}

				wind::json_object_t::const_iterator y = cobject.find("y");
				if (y == cobject.cend())
				{
					return -1;
				}

				path[index].x = x->get_as_number();
				path[index].y = y->get_as_number();

				++index;
			}

			return 0;
		}
	}
}