export module game:game_shared_data;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
export import :datafile;

namespace application
{
	class application_t;
}

namespace game
{
	namespace dungeon
	{
		export class dungeon_shared_data_tag_t;
		export using dungeon_shared_data_t = typename std::shared_ptr< dungeon_shared_data_tag_t>;
	}

	export class game_shared_data_t
	{
	public:
		game_shared_data_t();
		~game_shared_data_t();
		static auto get_datafile() -> const wind::datafile_t&;
		static auto get_buffer() -> const ALLEGRO::BITMAP&;
		static auto get_mouse() -> const ALLEGRO::POINT<float>&;
		static auto get_font() -> const wind::console::font_t;
		static auto get_dungeon_data() -> const dungeon::dungeon_shared_data_t&;
		static auto set_dungeon_data(const dungeon::dungeon_shared_data_t& data) -> void;

		friend application::application_t;
		static auto reset() -> void;

	private:

		static wind::datafile_t m_datafile;
		static ALLEGRO::BITMAP m_buffer;
		static ALLEGRO::POINT<float> m_mouse;
		static wind::console::font_t m_font;
		static dungeon::dungeon_shared_data_t m_dungeon;
	};
}

