export module game:process;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;

namespace game
{
	export class process_t
	{
	public:
		process_t();
		virtual ~process_t();
		virtual auto on_initialize() -> int32_t;
		virtual auto on_shutdown() -> int32_t;
		virtual auto on_start() -> int32_t;
		virtual auto on_stop() -> int32_t;
		virtual auto on_update() -> GAME::STATE;
		virtual auto on_render() -> void;
		auto get_process() const->GAME::PROCESS;
		auto get_sending_process() const->GAME::PROCESS;
		auto set_sending_process(GAME::PROCESS process) -> void;
		auto is_persistent() const  -> bool;
		auto set_persistence(bool value) -> void;
		virtual auto get_viewport() -> ALLEGRO::SIZE<int32_t> = 0;

	protected:
		bool m_persistent{ false };
		GAME::PROCESS m_process{ GAME::PROCESS::INVALID };
		GAME::PROCESS m_sending_process{ GAME::PROCESS::INVALID };
	};
}