export module game:faders;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;

namespace GAME
{
	namespace FADERS
	{
		export constexpr double DEFAULT_SPEED{ 1.0 };
		constexpr size_t DIVISIONS{ 50 };
	}
}

namespace game
{
	namespace faders
	{
		export auto in(const ALLEGRO::BITMAP& bitmap, double speed = GAME::FADERS::DEFAULT_SPEED) -> void;
		export auto out(const ALLEGRO::BITMAP& bitmap, double speed = GAME::FADERS::DEFAULT_SPEED) -> void;
		export auto out(double speed = GAME::FADERS::DEFAULT_SPEED) -> void;
		export auto in(double speed = GAME::FADERS::DEFAULT_SPEED) -> void;
		export auto across(const ALLEGRO::BITMAP& bitmap_a, const ALLEGRO::BITMAP& bitmap_b, double speed = GAME::FADERS::DEFAULT_SPEED) -> void;
	}
}