export module game:dungeon.trigger.base;

import <cstdint>;
import <vector>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item;

namespace game
{
	namespace dungeon
	{
		export class trigger_tag_t
		{
		public:
			trigger_tag_t();
			virtual ~trigger_tag_t();
			virtual auto evoke() -> int32_t = 0;
			virtual auto shutdown() -> void = 0;
			virtual auto on_update() -> void = 0;
			virtual auto on_render() -> void = 0;
			auto get_type() const->GAME::DUNGEON::TRIGGER::TYPE;
			auto set_type(GAME::DUNGEON::TRIGGER::TYPE type) -> void;
			auto get_state() const->GAME::DUNGEON::TRIGGER::STATE;
			auto set_state(GAME::DUNGEON::TRIGGER::STATE state) -> void;
			auto get_index() const->int32_t;
			auto set_index(int32_t index) -> void;
			auto get_flags() const->int32_t;
			auto set_flags(int32_t flags) -> void;

		protected:
			GAME::DUNGEON::TRIGGER::TYPE m_type{ GAME::DUNGEON::TRIGGER::TYPE::INVALID };
			GAME::DUNGEON::TRIGGER::STATE m_state{ GAME::DUNGEON::TRIGGER::STATE::INVALID };
			int32_t m_index{ -1 };
			int32_t m_flags{ 0 };
		};

		
	}
}