export module game:dungeon.dungeon_shared_data;

import <cstdint>;
import <vector>;
import <memory>;
import <array>;
import <map>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item.base;

namespace game
{
	namespace dungeon
	{
		namespace item
		{
			namespace icon
			{
				export using tilesheet_t = typename std::shared_ptr<wind::tilesheet_t>;
				export using name_map_t = typename std::map<wind::string_t, int32_t>;
			}
		}

		export class dungeon_shared_data_tag_t
		{
		public:
			dungeon_shared_data_tag_t();
			~dungeon_shared_data_tag_t();
			auto get_icon_tilesheet(GAME::DUNGEON::ITEM::TYPE type) const -> const item::icon::tilesheet_t&;
			auto get_icon_index(GAME::DUNGEON::ITEM::TYPE type, const wind::string_t& name) const-> int32_t;
			auto set_icon_tilesheet(GAME::DUNGEON::ITEM::TYPE type, const item::icon::tilesheet_t& tilesheet) -> void;
			auto reset() -> void;
			auto get_icon_name_map(GAME::DUNGEON::ITEM::TYPE type) -> item::icon::name_map_t&;
			auto get_icon_name_map(GAME::DUNGEON::ITEM::TYPE type) const -> const item::icon::name_map_t&;

			friend class dungeon_t;

		private:
			std::array<item::icon::tilesheet_t, std::to_underlying(GAME::DUNGEON::ITEM::TYPE::COUNT)> m_icon_tilesheets;
			std::array<item::icon::name_map_t, std::to_underlying(GAME::DUNGEON::ITEM::TYPE::COUNT)> m_icon_name_maps;
		};

		export using dungeon_shared_data_t = typename std::shared_ptr< dungeon_shared_data_tag_t>;
	}
}
