export module game:dungeon.player.data;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :dungeon.base;
import :dungeon.item;

namespace game
{
	namespace dungeon
	{
		namespace player
		{
			export class data_tag_t
			{
			public:
				data_tag_t();
				~data_tag_t();
				auto get_items() const -> const std::array<item_t, GAME::DUNGEON::INVENTORY::COUNT>&;
				auto get_items() -> std::array<item_t, GAME::DUNGEON::INVENTORY::COUNT>&;
				auto get_slot(size_t slot_index) -> item_t&;
				auto get_slot(size_t slot_index) const -> const item_t&;
				auto get_key() const -> bool;
				auto set_key(bool key) -> void;
				auto get_money() const->int32_t;
				auto set_money(int32_t money) -> void;
				auto get_floor() -> int32_t;
				auto set_floor(int32_t floor) -> void;

			private:
				std::array<item_t, GAME::DUNGEON::INVENTORY::COUNT> m_items{};
				int32_t m_floor{ -1 };
				int32_t m_money{ 0 };
				bool m_key{ false };
			};

			export using data_t = typename std::shared_ptr<data_tag_t>;
		}
	}
}
