export module game:dungeon.player;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.movable;
import :dungeon.map;
import :dungeon.item;
export import :dungeon.player.data;

namespace game
{
	namespace dungeon
	{
		export class player_t : public movable_t
		{
		public:
			player_t();
			~player_t();
			auto on_initialize() -> int32_t;
			auto on_shutdown() -> void;
			auto on_update() -> void override;
			auto on_render(const map::camera_t& camera, const ALLEGRO::POINT<float>& position) const  -> void override;
			auto get_data() const -> const player::data_t&;
			auto get_data() -> player::data_t&;

		private:
			player::data_t m_data{};
		};
	}
}
