export module game:dungeon.movable;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.map;

namespace game
{
	namespace dungeon
	{
		export class movable_t
		{
		public:
			movable_t();
			virtual ~movable_t();

			
			auto on_shutdown() -> void;

			auto get_bitmap() const -> const ALLEGRO::BITMAP&;
			auto get_position() const -> const ALLEGRO::POINT<float>&;
			auto get_x() const->int32_t;
			auto get_y() const->int32_t;
			auto get_hp() const->int32_t;
			auto get_max_hp() const->int32_t;
			auto get_facing() const->GAME::DIRECTION;
			auto get_frame() const->int32_t;
			auto get_moved() const -> bool;

			auto set_bitmap(const ALLEGRO::BITMAP& bitmap) -> void;
			auto set_position(const ALLEGRO::POINT<float>& position) -> void;
			auto set_x(int32_t value) -> void;
			auto set_y(int32_t value) -> void;
			auto set_hp(int32_t value) -> void;
			auto set_max_hp(int32_t value) -> void;
			auto set_facing(GAME::DIRECTION value) -> void;
			auto set_frame(int32_t value) -> void;
			auto set_moved(bool value) -> void;
			virtual auto on_update() -> void = 0;
			virtual auto on_render(const map::camera_t& camera, const ALLEGRO::POINT<float>& position) const  -> void = 0;

		protected:
			ALLEGRO::BITMAP m_bitmap{};
			ALLEGRO::POINT<float> m_position{ 0.0f, 0.0f };
			int32_t m_hp{ 0 };
			int32_t m_max_hp{ 0 };
			GAME::DIRECTION m_facing{ 0 };
			int32_t m_frame{ 0 };
			bool m_moved{ false };
		};
	}
}