export module game:dungeon.map.outline;

import <cstdint>;
import <vector>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;

namespace game
{
	namespace dungeon
	{
		namespace map
		{
			namespace outline
			{
				export using room_t = ALLEGRO::BOX<int32_t>;
				export using door_t = ALLEGRO::POINT<int32_t>;
			}

			export using outline_t = struct outline_tag_t
			{
				std::vector<outline::room_t> m_rooms{};
				std::vector<outline::door_t> m_doors{};
				ALLEGRO::SIZE<int32_t> m_size;
				size_t m_start{ 0 };
				size_t m_finish{ 0 };
			};

			namespace outline
			{
				export auto generate(outline_t& outline, size_t direct_count, size_t extra_count = 0) -> int32_t;
#ifdef _DEBUG
				export auto draw(const outline_t& outline, const ALLEGRO::POINT<int32_t>& position = { 0, 0 }) -> void;
#endif
			}
		}
	}
}