export module game:dungeon.level;

import <cstdint>;
import <vector>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;

namespace game
{
	namespace dungeon
	{
		export class level_t
		{
		public:
			using element_type = int32_t;
			using pointer_element_type = wind::add_pointer<element_type>::type;
			using const_pointer_element_type = wind::add_pointer<wind::add_const<element_type>::type>::type;
			using reference_element_type = wind::add_reference<element_type>::type;
			using const_reference_element_type = wind::add_reference<wind::add_const<element_type>::type>::type;

		private:
			using vector_type = std::vector<std::shared_ptr<element_type>>;

		public:
			level_t();
			level_t(const level_t& level);
			~level_t();
			auto operator = (const level_t& level)->level_t&;
			auto clear() -> void;
			auto count() const->size_t;
			auto operator[](size_t index)->reference_element_type;
			auto operator[](size_t index) const->const_reference_element_type;
			auto at(size_t index) -> reference_element_type;
			auto at(size_t index) const->const_reference_element_type;
			auto push_back(const_reference_element_type room) -> void;
			auto pop_back() -> void;
			auto get_data() const -> const void*;
			auto get_data() -> void*;

			class iterator
			{
			private:
				iterator() = default;
			public:
				iterator(vector_type::iterator it) : m_it(it) {}
				auto operator == (const iterator& it) const -> bool { return (this->m_it == it.m_it); }
				auto operator != (const iterator& it) const -> bool { return !operator == (it); }
				auto operator ++ () -> iterator& { ++this->m_it; return *this; }
				auto operator ++ (int32_t) -> iterator { iterator tmp = *this; ++(*this); return tmp; }
				auto operator * () -> reference_element_type { return *((this->m_it.operator*()).get()); }
				auto operator -> () -> pointer_element_type { return (this->m_it.operator*()).get(); }

			private:
				vector_type::iterator m_it;
			};

			class const_iterator
			{
			private:
				const_iterator() = default;
			public:
				const_iterator(vector_type::const_iterator it) : m_it(it) {}

				auto operator == (const const_iterator& it) const -> bool { return (this->m_it == it.m_it); }
				auto operator != (const const_iterator& it) const -> bool { return !operator == (it); }
				auto operator ++ () -> const_iterator& { ++this->m_it; return *this; }
				auto operator ++ (int32_t) -> const_iterator { const_iterator tmp = *this; ++(*this); return tmp; }
				auto operator * () const -> const_reference_element_type { return *((this->m_it.operator*()).get()); }
				auto operator -> () const -> const_pointer_element_type { return (this->m_it.operator*()).get(); }

			private:
				vector_type::const_iterator m_it;
			};

			auto begin() -> iterator;
			auto end() -> iterator;
			auto cbegin() const->const_iterator;
			auto cend() const->const_iterator;

		private:
			vector_type m_rooms{};
		};
	}
}