export module game:dungeon.map.generator;

import <vector>;
import <cstdint>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.map.cell;
import :dungeon.map;
import :dungeon.map.outline;

namespace game
{
	namespace dungeon
	{
		namespace map
		{
			export class generator_t
			{
			public:
				static auto generate(map_t& map, bool is_bottom_floor = false) -> int32_t;

			private:
				generator_t();
				~generator_t();
				generator_t(const generator_t& generator) = delete;
				generator_t(const generator_t&& generator) = delete;
				auto operator = (const generator_t& generator)->generator_t & = delete;
				auto run() -> int32_t;

				auto populate_map() -> int32_t;
				auto populate_room(const outline::room_t& room) -> int32_t;
				auto find_door_rooms(const outline::door_t& door, size_t(&rooms)[2]) -> void;
				auto is_door_to_room(const outline::room_t& room, const outline::door_t& door) -> bool;
				auto find_room_center(const outline::room_t& room) -> ALLEGRO::POINT<int32_t>;

				map_t* m_map{ nullptr };
				outline_t m_outline{};
				bool m_bottom{ false };
			};
		}
	}
}