export module game:dungeon.map.cell;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;

namespace game
{
	namespace dungeon
	{
		class map_t;
		namespace map
		{
			class generator_t;

			namespace cell
			{
				export using shared_data_t = struct data_tag_t
				{
					union
					{
						uint32_t m_value{ 0 };
						struct
						{
							uint32_t m_visible : 1;
							uint32_t m_edge : 1;
							uint32_t m_floor : 8;
							uint32_t m_wall : 8;
							uint32_t m_object : 8;
							uint32_t m_blocked : 1;
							uint32_t m_npc : 1;
							uint32_t m_trigger : 1;
							uint32_t m_fluff : 3;
						};
					};
				};
			}

			export class cell_t
			{
			public:
				cell_t();
				explicit cell_t(uint32_t value);
				explicit cell_t(const cell::shared_data_t& data);
				cell_t(const cell_t& cell);
				~cell_t();
				auto operator = (const cell_t& cell)->cell_t&;
				explicit operator uint32_t () const;
				explicit operator const cell::shared_data_t& () const;
				auto set_value(uint32_t value) -> void;
				auto get_value() const->uint32_t;
				auto set_attribute(size_t index, uint32_t value) -> void;
				auto get_attribute(size_t index) const->uint32_t;
				auto get_visible() const->uint32_t;
				auto get_edge() const->uint32_t;
				auto get_floor_tile() const->uint32_t;
				auto get_wall_tile() const->uint32_t;
				auto get_object_tile() const->uint32_t;
				auto get_blocked() const->uint32_t;
				auto get_npc() const->uint32_t;
				auto get_trigger() const->uint32_t;
				auto get_fluff() const->uint32_t;
				auto set_visible(uint32_t value) -> void;
				auto set_edge(uint32_t value) -> void;
				auto set_floor_tile(uint32_t value) -> void;
				auto set_wall_tile(uint32_t value) -> void;
				auto set_object_tile(uint32_t value) -> void;
				auto set_blocked(uint32_t value) -> void;
				auto set_npc(uint32_t value) -> void;
				auto set_trigger(uint32_t value) -> void;
				auto set_fluff(uint32_t value) -> void;
				auto draw(const std::shared_ptr<wind::tilesheet_t>& tilesheet, const ALLEGRO::POINT<int32_t>& position, bool debug_mode = false) const -> void;

				friend class map::generator_t;
				friend class map_t;
			private:
				cell::shared_data_t m_data;
			};
		}
	}
}