export module game:dungeon.map.camera;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;

namespace game
{
	namespace dungeon
	{
		namespace map
		{
			export class camera_t
			{
			public:
				camera_t();
				camera_t(const camera_t& camera);
				~camera_t();
				camera_t& operator = (const camera_t& camera);
				camera_t& operator = (const ALLEGRO::POINT<float>& position);
				auto follow(const ALLEGRO::POINT<float>& player) -> void;
				auto update() -> void;
				auto move(const ALLEGRO::POINT<float>& delta) -> void;
				auto get_position() const ->const ALLEGRO::POINT<float>&;
				auto set_position(const ALLEGRO::POINT<float>& position) -> void;

			private:
				std::shared_ptr<const ALLEGRO::POINT<float>> m_player{};
				ALLEGRO::POINT<float> m_velocity{ 0.0f, 0.0f };
				ALLEGRO::POINT<float> m_position{ 0.0f, 0.0f };
			};
		}
	}
}