export module game:dungeon.item.weapon;

import <cstdint>;
import <vector>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.dice;
import :dungeon.item.base;

namespace game
{
	namespace dungeon
	{
		namespace item
		{
			namespace weapon
			{
				export using damage_t = typename std::pair<int32_t, dice_t>;
			}

			export class weapon_t : public item_data_t
			{
			public:

				weapon_t();
				~weapon_t();
				auto clone() const->item_t override;
				auto get_damage() const->const weapon::damage_t&;
				auto set_damage(const weapon::damage_t& damage) -> void;
				auto get_versatile() const->const weapon::damage_t&;
				auto set_versatile(const weapon::damage_t& damage) -> void;
				auto get_property() const->int32_t;
				auto set_property(int32_t property) -> void;

			private:
				weapon::damage_t m_damage{};
				weapon::damage_t m_versatile{};
				int32_t m_property{};
			};

			namespace weapon
			{
				export auto parse_icons(wind::json_array_t&) -> int32_t;
				export auto reset() -> void;
				export auto parser(const wind::json_object_t& json) -> item_t;
			}
		}
	}
}