export module game:dungeon.item.parser;

import <cstdint>;
import <vector>;
import <memory>;
import <map>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item.base;
import :dungeon.item.list;

namespace game
{
	namespace dungeon
	{
		namespace item
		{
			export using parser_func_t = typename auto (*)(const wind::json_object_t& json) -> item_t;

			export auto register_parser(const wind::string_t& type, parser_func_t parser) -> void;
			export auto parse_file(const wind::string_t& filename, list_t& list) -> int32_t;
			export auto parse_file_from_archive(const wind::string_t& archive_filename, const wind::string_t& filename, list_t& list) -> int32_t;
			export auto parse_json(const wind::json_t& json, list_t& list) -> int32_t;
			export auto parse_currency(const wind::string_t& cost) -> int32_t;
			export auto convert_currency_to_string(int32_t amount) -> wind::string_t;
		}
	}
}