export module game:dungeon.item.list;

import <cstdint>;
import <vector>;
import <memory>;
import <map>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item.base;

namespace game
{
	namespace dungeon
	{
		namespace item
		{
			export class list_t
			{
			public:
				using map_key_type = typename wind::string_t;
				using element_type = typename dungeon::item_t;
				using pointer_element_type = typename wind::add_pointer<element_type>::type;
				using const_pointer_element_type = typename wind::add_pointer<const element_type>::type;
				using reference_element_type = typename wind::add_reference<element_type>::type;
				using const_reference_element_type = typename wind::add_reference<const element_type>::type;

			private:
				using vector_type = typename std::vector<element_type>;
				using map_type = typename std::map<map_key_type, size_t>;

			public:
				list_t();
				list_t(const list_t& list);
				~list_t();
				list_t& operator = (const list_t& list);
				auto clear() -> void;
				auto size() const->size_t;
				auto at(size_t index) -> reference_element_type;
				auto at(size_t index) const->const_reference_element_type;
				auto operator [](size_t index)->reference_element_type;
				auto operator [](size_t index) const->const_reference_element_type;
				auto add(const map_key_type& key, element_type& element) -> void;
				auto exists(const map_key_type& key) const -> bool;

				using pair_t = typename std::pair<const map_key_type&, reference_element_type>;
				using const_pair_t = typename std::pair<const map_key_type&, const_reference_element_type>;

				auto get_by_type(GAME::DUNGEON::ITEM::TYPE type, std::vector<pair_t>& vector) -> size_t;
				auto get_by_type(GAME::DUNGEON::ITEM::TYPE type, std::vector<const_pair_t>& vector) const -> size_t;

				class iterator
				{
				private:
					iterator() = default;
				public:
					iterator(vector_type& data, map_type& map, map_type::iterator iter) : m_data(&data), m_map(&map), m_iterator(iter) {}
					auto key() const -> const wind::string_t&
					{
						ALLEGRO::ASSERT(this->m_data && this->m_iterator != this->m_map->cend());
						return this->m_iterator->first;
					}
					auto operator == (iterator& it) const -> bool { return (this->m_iterator == it.m_iterator); }
					auto operator != (iterator& it) const -> bool { return !operator == (it); }
					auto operator ++ () -> iterator& { ++this->m_iterator; return *this; }
					auto operator ++ (int32_t) -> iterator { iterator tmp = *this; ++(*this); return tmp; }
					auto operator * () -> reference_element_type
					{
						ALLEGRO::ASSERT(this->m_data && this->m_iterator != this->m_map->cend());
						return this->m_data->at(this->m_iterator->second);
					}
					auto operator -> () -> pointer_element_type
					{
						ALLEGRO::ASSERT(this->m_data && this->m_iterator != this->m_map->cend());
						return &this->m_data->at(this->m_iterator->second);
					}

				private:
					vector_type* m_data{ nullptr };
					map_type* m_map{ nullptr };
					map_type::iterator m_iterator;
				};

				class const_iterator
				{
				private:
					const_iterator() = default;
				public:
					const_iterator(const vector_type& data, const map_type& map, map_type::const_iterator iter) : m_data(&data), m_map(&map), m_iterator(iter) {}
					auto key() const -> const wind::string_t&
					{
						ALLEGRO::ASSERT(this->m_data && this->m_iterator != this->m_map->cend());
						return this->m_iterator->first;
					}
					auto operator == (const_iterator& it) const -> bool { return (this->m_iterator == it.m_iterator); }
					auto operator != (const_iterator& it) const -> bool { return !operator == (it); }
					auto operator ++ () -> const_iterator& { ++this->m_iterator; return *this; }
					auto operator ++ (int32_t) -> const_iterator { const_iterator tmp = *this; ++(*this); return tmp; }
					auto operator * () const  -> const_reference_element_type
					{
						ALLEGRO::ASSERT(this->m_data && this->m_iterator != this->m_map->cend());
						return this->m_data->at(this->m_iterator->second);
					}
					auto operator -> () const  -> const_pointer_element_type
					{
						ALLEGRO::ASSERT(this->m_data && this->m_iterator != this->m_map->cend());
						return &this->m_data->at(this->m_iterator->second);
					}

				private:
					const vector_type* m_data{ nullptr };
					const map_type* m_map{ nullptr };
					map_type::const_iterator m_iterator;
				};

				auto find(const map_key_type& key) -> map_type::iterator;
				auto find(const map_key_type& key) const->map_type::const_iterator;

				auto begin() -> iterator;
				auto end() -> iterator;
				auto cbegin() const->const_iterator;
				auto cend() const->const_iterator;

			private:
				vector_type m_data{};
				map_type m_index{};
			};

			namespace list
			{
				export auto load_items(const wind::string_t& filename, list_t& list) -> int32_t;
				export auto load_items_from_archive(const wind::string_t& archive_filename, const wind::string_t& filename, list_t& list) -> int32_t;
			}
		}
	}
}