export module game:dungeon.item.icons;

import <cstdint>;
import <vector>;
import <memory>;
import allegro;
import wind;
import :base;
import :dungeon.base;
import :dungeon.item.base;

namespace game
{
	namespace dungeon
	{
		namespace item
		{
			namespace icon
			{
				export auto get_index(GAME::DUNGEON::ITEM::TYPE type, const wind::string_t& name) -> int32_t;
				export auto get_bitmap(GAME::DUNGEON::ITEM::TYPE type, int32_t index) -> const ALLEGRO::BITMAP&;
				export auto set_tilesheet(GAME::DUNGEON::ITEM::TYPE type, const wind::tilesheet_t& tilesheet) -> void;
				export auto load(const wind::string_t& filename) -> int32_t;
				export auto load_from_archive(const wind::string_t& archive_filename, const wind::string_t& filename) -> int32_t;
			}
		}
	}
}