export module game:dungeon.item.base;

import <cstdint>;
import <vector>;
import <memory>;
import <map>;
import allegro;
import wind;
import :base;
import :dungeon.base;

namespace GAME
{
	namespace DUNGEON
	{
		export enum class CURRENCY : int32_t
		{
			INVALID = -1,
			COPPER,
			SILVER,
			GOLD,
			PLATINUM,
			COUNT
		};

		namespace ITEM
		{
			export enum class TYPE : int32_t
			{
				INVALID = -1,
				ARMOR,
				FOOD,
				POTION,
				TREASURE,
				WEAPON,
				COUNT
			};

			export enum class COLOR : int32_t
			{
				INVALID = -1,
				BLACK,
				BLUE,
				GREEN,
				CYAN,
				RED,
				MAGENTA,
				BROWN,
				WHITE,
				GRAY,
				BRIGHT_BLUE,
				BRIGHT_GREEN,
				BRIGHT_CYAN,
				BRIGHT_RED,
				PINK,
				YELLOW,
				BRIGHT_WHITE,
				COUNT
			};

			namespace ARMOR
			{
				export enum class ICON : int32_t
				{
					INVALID = -1,
					NONE,
					LEATHER,
					STUDDED_LEATHER,
					HIDE,
					RING_MAIL,
					CHAIN_MAIL,
					PLATE,
					SHIELD,
					COUNT
				};
			}

			namespace WEAPON
			{
				export enum class TYPE : int32_t
				{
					INVALID = -1,
					MELEE,
					RANGED,
					COUNT
				};

				namespace ATTRIBUTE
				{
					export enum
					{
						COST,
						DAMAGE,
						DAMAGE_TYPE,
						WEIGHT,
						PROPERTY,
						COUNT
					};
				}

				namespace DAMAGE_TYPE
				{
					export constexpr int32_t NONE = 0;
					export constexpr int32_t BLUDGEONING = 0x01;
					export constexpr int32_t PIERCING = (BLUDGEONING << 1);
					export constexpr int32_t SLASHING = (PIERCING << 1);
				}

				namespace PROPERTY
				{
					export constexpr int32_t NONE = 0;
					export constexpr int32_t FINESSE = 1;
					export constexpr int32_t HEAVY = (FINESSE << 1);
					export constexpr int32_t LIGHT = (HEAVY << 1);
					export constexpr int32_t THROWN = (LIGHT << 1);
					export constexpr int32_t TWO_HANDED = (THROWN << 1);
					export constexpr int32_t VERSATILE = (TWO_HANDED << 1);
				}
			}
		}
	}
}

namespace game
{
	namespace dungeon
	{
		class item_data_t;
		export using item_t = typename std::shared_ptr<item_data_t>;

		export class item_data_t
		{
		public:
			item_data_t();
			virtual ~item_data_t();
			auto get_type() const->GAME::DUNGEON::ITEM::TYPE;
			auto set_type(GAME::DUNGEON::ITEM::TYPE type) -> void;
			auto get_name() const -> const wind::string_t&;
			auto set_name(const wind::string_t& name) -> void;
			auto get_icon() const->int32_t;
			auto set_icon(int32_t icon) -> void;
			auto get_cost() const->int32_t;
			auto set_cost(int32_t cost) -> void;
			auto get_weight() const->int32_t;
			auto set_weight(int32_t weight) -> void;
			virtual auto clone() const-> item_t = 0;

		protected:
			GAME::DUNGEON::ITEM::TYPE m_type{ GAME::DUNGEON::ITEM::TYPE::INVALID };
			wind::string_t m_name{ "[ITEM]" };
			int32_t m_icon{ 0 };
			int32_t m_cost{ 0 };
			int32_t m_weight{ 0 };
		};

	}
}