export module game:dungeon.inventory.layout;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :dungeon.base;

namespace game
{
	namespace dungeon
	{
		namespace inventory
		{
			export class layout_t
			{
			public:
				layout_t();
				~layout_t();
				auto get_screen_size() const -> const ALLEGRO::SIZE<int32_t>&;
				auto get_sara_position() const -> const ALLEGRO::POINT<int32_t>&;
				auto get_treasure_array() const -> const std::array<ALLEGRO::POINT<int32_t>, GAME::DUNGEON::INVENTORY::TREASURE::COUNT>&;
				auto get_equipped_caption_position() const -> const ALLEGRO::POINT<int32_t>&;
				auto get_slot_array() const -> const std::array<ALLEGRO::POINT<int32_t>, GAME::DUNGEON::INVENTORY::COUNT>;
				auto load_manifest(const wind::string_t& filename) -> int32_t;
				auto get_key_position() const -> const ALLEGRO::POINT<int32_t>&;

			private:
				ALLEGRO::SIZE<int32_t> m_screen_size{ GAME::BUFFER::SIZE };
				ALLEGRO::POINT<int32_t> m_sara_position{ 0, 0 };
				std::array<ALLEGRO::POINT<int32_t>, GAME::DUNGEON::INVENTORY::TREASURE::COUNT> m_treasure_array{};
				ALLEGRO::POINT<int32_t> m_equipped_caption_postion{ 0, 0 };
				std::array<ALLEGRO::POINT<int32_t>, GAME::DUNGEON::INVENTORY::COUNT> m_slot_array{};
				ALLEGRO::POINT<int32_t> m_key_position{ 0, 0 };
			};
		}
	}
}