export module game:dungeon.inventory;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :dungeon.base;
import :dungeon.item;
export import :dungeon.inventory.base;
export import :dungeon.inventory.layout;
import :dungeon.player;

namespace game
{
	namespace dungeon
	{
		export class inventory_t
		{
		public:
			inventory_t();
			~inventory_t();

			auto on_initialize() -> int32_t;
			auto on_shutdown() -> void;
			auto on_update() -> GAME::DUNGEON::STATE;
			auto on_render() -> void;
			auto get_viewport() -> ALLEGRO::SIZE<int32_t>;

			auto get_data() const -> const player::data_t&;
			auto set_data(const player::data_t& data) -> void;

		private:
			auto do_mouse_down(int32_t slot_index) -> void;
			auto do_mouse_up(int32_t slot_index) -> void;

			inventory::layout_t m_layout{};
			player::data_t m_data{};
			int32_t m_inhand{ -1 };
		};
	}
}

