export module game:dungeon.base;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;

namespace GAME
{
	namespace DUNGEON
	{
		namespace INVENTORY
		{
			namespace LAYOUT
			{
				export const char* MANIFEST_FILE{ "inventory_layout.json" };
			}

			namespace SLOT
			{
				export constexpr int32_t WIDTH{ 4 };
				export constexpr int32_t HEIGHT{ 5 };
				export constexpr int32_t COUNT{ WIDTH * HEIGHT };
				export constexpr ALLEGRO::SIZE<int32_t> SIZE{ 36, 36 };
			}

			namespace TREASURE
			{
				export constexpr int32_t COUNT = 8;
				export constexpr ALLEGRO::SIZE<int32_t> SIZE{ 36, 36 };
			}

			export enum class EQUIPPED : int32_t
			{
				INVALID = -1,
				LEFT,
				RIGHT,
				BODY,
				COUNT
			};

			export constexpr int32_t TRASH{ SLOT::COUNT + std::to_underlying(EQUIPPED::COUNT) };
			export constexpr int32_t COUNT{ TRASH + 1 };
		}

		export enum class STATE : int32_t
		{
			INVALID = -1,
			INITIALIZING,
			STARTING,
			WAITING,
			INPUT,
			WALKING,
			ATTACKING,
			STOPPING,
			CLOSING,
			INVENTORY,
			TRIGGER,
			GAMEOVER,
			SHUTDOWN
		};

		namespace TRIGGER
		{
			export enum class STATE : int32_t
			{
				INVALID = -1,
				DEACTIVATED,
				LIVE
			};

			export enum class TYPE : int32_t
			{
				INVALID = -1,
				SKELETON,
				DOOR,
				CHEST,
				STAIR_UP,
				STAIR_DOWN,
				COUNT
			};

			namespace FLAG
			{
				export constexpr int32_t VISIBLE = 0x01;
				export constexpr int32_t STEP_INTO = (VISIBLE << 1);
				export constexpr int32_t INPUT_REQUIRED = (STEP_INTO << 1);
				export constexpr int32_t PROXIMITY = (INPUT_REQUIRED << 1);
				export constexpr int32_t LAST = PROXIMITY;
			}

			namespace DOOR
			{
				export enum class TYPE
				{
					INVALID = -1,
					STANDARD,
					SEALED,
					BOSS,
					COUNT
				};

				namespace FLAG
				{
					export constexpr int32_t KEY_REQUIRED = (TRIGGER::FLAG::LAST << 1);
				}
			}
		}


		namespace TILE
		{
			export constexpr ALLEGRO::POINT<int32_t> SHIFT{ 5, 5 };
			export constexpr ALLEGRO::SIZE<int32_t> SIZE{ 1 << SHIFT.x, 1 << SHIFT.y };
		}

		namespace MOVEMENT
		{
			export constexpr float DELAY = 0.35f;
			export constexpr float TICK = DELAY / 20.0f;
		}

		namespace GENERATOR
		{
			export constexpr size_t DIRECT_ROOMS = 10;
			export constexpr size_t EXTRA_ROOMS = 5;
		}

		namespace CAMERA
		{
			export constexpr ALLEGRO::SIZE<int32_t> VIEWPORT{ 11, 9 };
		}

		namespace OUTLINE
		{
			export constexpr ALLEGRO::SIZE<int32_t> MINIMUM{ (CAMERA::VIEWPORT.width - 1) >> 1, (CAMERA::VIEWPORT.height - 1) >> 1 };
			export constexpr ALLEGRO::SIZE<int32_t> MAXIMUM{ 2, 2 };
			export constexpr size_t SHUFFLE_COUNT = 20;
			export constexpr int32_t DOOR_VARIANCE = 2;
			export constexpr int32_t MAP_PADDING = 10;
		}

		namespace CELL
		{
			namespace ATTRIBUTE
			{
				export enum : int32_t
				{
					VISIBLE,
					EDGE,
					FLOOR,
					TILE,
					OBJECT,
					BLOCKED,
					NPC,
					TRIGGER,
					FLUFF,
					COUNT
				};
			}

			namespace TYPE
			{
				export enum : int32_t
				{
					BLANK,
					FLOOR_BRICK,
					FLOOR_COBBLE_GREEN,
					FLOOR_COBBLE_DARK,
					FLOOR_COBBLE_LIGHT,
					FLOOR_WOODEN_PLANK,
					SKELETON,
					WATER,
					LAVA,
					WALL_BRICK,
					WALL_BRICK_LICHEN,
					WALL_BRICK_WATER_FEATURE,
					WALL_BRICK_KNIGHT,
					WALL_BRICK_WINDOW,
					WALL_BRICK_WINDOW_BARRED,
					WALL_BRICK_PILLARS,
					WALL_BRICK_GODDESS_STATUE,
					DOOR_BRICK_STANDARD_CLOSED,
					DOOR_BRICK_STANDARD_OPEN,
					DOOR_BRICK_SEALED_CLOSED,
					DOOR_BRICK_SEALED_OPEN,
					DOOR_BRICK_BOSS_CLOSED,
					DOOR_BRICK_BOSS_OPEN,
					STAIR_DOWN,
					STAIR_UP,
					ROCK,
					WELL,
					PILLAR,
					BARREL,
					GRAVE_STONE,
					GRAVE_CROSS,
					SPIKE_DOWN,
					SPIKE_UP,
					BOX,
					SCONCE_FLOOR,
					SCONSE_FLOOR_FIRE,
					FIRE_WALL,
					GODDESS_STATUE,
					POT,
					SCONCE_WALL,
					TABLET,
					CHEST_STANDARD_CLOSED,
					CHEST_STANDARD_OPEN,
					CHEST_BOSS_CLOSED,
					CHEST_BOSS_OPEN,
					DEBRIS_PEBBLES,
					DEBRIS_GRASS_000,
					DEBRIS_GRASS_001,
					DEBRIS_BONES,
					DEBRIS_BLOOD,
					COUNT
				};
			}
		}
	}
}

namespace game
{

	namespace dungeon
	{
		export auto get_delta(GAME::DIRECTION direction) -> ALLEGRO::POINT<int32_t>;
	}
}