export module game:dungeon.bag;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :dungeon.base;
import :dungeon.item;

namespace game
{
	namespace dungeon
	{
		export class bag_tag_t
		{
		public:
			using element_type = dungeon::item_t;
			using pointer_element_type = wind::add_pointer<element_type>::type;
			using const_pointer_element_type = wind::add_pointer<const element_type>::type;
			using reference_element_type = wind::add_reference<element_type>::type;
			using const_reference_element_type = wind::add_reference<const element_type>::type;

		private:
			using vector_type = wind::array_t<element_type>;

		public:
			bag_tag_t(size_t size);
			~bag_tag_t();
			auto clear() -> void;
			auto data() -> void*;
			auto data() const -> const void*;
			auto size() const->size_t;
			auto at(size_t index) -> reference_element_type;
			auto at(size_t index) const->const_reference_element_type;
			auto operator [](size_t index)->reference_element_type;
			auto operator [](size_t index) const->const_reference_element_type;

			class iterator
			{
			private:
				iterator() = default;
			public:
				iterator(vector_type& data, size_t offset) : m_data(&data), m_offset(offset) {}
				auto operator == (iterator& it) const -> bool { return (this->m_data == it.m_data && this->m_offset == it.m_offset); }
				auto operator != (iterator& it) const -> bool { return !operator == (it); }
				auto operator ++ () -> iterator& { ++this->m_offset; return *this; }
				auto operator ++ (int32_t) -> iterator { iterator tmp = *this; ++(*this); return tmp; }
				auto operator * () -> reference_element_type
				{
					ALLEGRO::ASSERT(m_data && m_offset < m_data->get_count());
					return ((*this->m_data)[this->m_offset]);
				}
				auto operator -> () -> pointer_element_type
				{
					ALLEGRO::ASSERT(m_data && m_offset < m_data->get_count());
					return &((*this->m_data)[this->m_offset]);
				}

			private:
				vector_type* m_data;
				size_t m_offset;
			};

			class const_iterator
			{
			private:
				const_iterator() = default;
			public:
				const_iterator(const vector_type& data, size_t offset) : m_data(&data), m_offset(offset) {}
				auto operator == (const const_iterator& it) const -> bool { return (this->m_data == it.m_data && this->m_offset == it.m_offset); }
				auto operator != (const const_iterator& it) const -> bool { return !operator == (it); }
				auto operator ++ () -> const_iterator& { ++this->m_offset; return *this; }
				auto operator ++ (int32_t) -> const_iterator { const_iterator tmp = *this; ++(*this); return tmp; }
				auto operator * () const -> const_reference_element_type
				{
					ALLEGRO::ASSERT(m_data && m_offset < m_data->get_count());
					return ((*this->m_data)[this->m_offset]);
				}
				auto operator -> () const -> const_pointer_element_type
				{
					ALLEGRO::ASSERT(m_data && m_offset < m_data->get_count());
					return &((*this->m_data)[this->m_offset]);
				}

			private:
				const vector_type* m_data{ nullptr };
				size_t m_offset{ 0 };
			};

			auto begin() -> iterator;
			auto end() -> iterator;
			auto cbegin() const->const_iterator;
			auto cend() const->const_iterator;

		private:
			bag_tag_t();
			vector_type m_data{};
		};

		export using bag_t = typename std::shared_ptr<bag_tag_t>;
	}
}
