export module game:dungeon;

import <cstdint>;
import <memory>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :process;
import :game_shared_data;
export import :dungeon.base;
export import :dungeon.dice;
export import :dungeon.item;
export import :dungeon.map;
export import :dungeon.player;
export import :dungeon.dungeon_shared_data;
export import :dungeon.trigger;
export import :dungeon.inventory;
export import :dungeon.player;

namespace game
{
	export class dungeon_t : public process_t
	{
	public:
		dungeon_t();
		~dungeon_t();

		auto on_initialize() -> int32_t override;
		auto on_shutdown() -> int32_t override;
		auto on_start() -> int32_t override;
		auto on_stop() -> int32_t override;
		auto on_update() -> GAME::STATE override;
		auto on_render() -> void override;
		auto get_viewport() -> ALLEGRO::SIZE<int32_t> override;
		auto get_state() const->GAME::DUNGEON::STATE;
		auto set_state(GAME::DUNGEON::STATE state) -> void;
		auto get_map() -> dungeon::map_t&;
		auto get_map() const -> const dungeon::map_t&;
		auto get_player() -> dungeon::player_t&;
		auto get_player() const -> const dungeon::player_t&;
		auto get_camera() -> dungeon::map::camera_t&;
		auto get_camera() const -> const dungeon::map::camera_t&;

	private:
		auto ascend() -> int32_t;
		auto descend() -> int32_t;
		auto process_trigger(size_t index) -> int32_t;

		GAME::DUNGEON::STATE m_state{ GAME::DUNGEON::STATE::INVALID };
		dungeon::dungeon_shared_data_t m_data{};
		dungeon::map_t m_map{};
		dungeon::player_t m_player{};
		dungeon::map::camera_t m_camera{};
		dungeon::item::list_t m_item_list{};
		dungeon::trigger_t m_trigger{};
		dungeon::inventory_t m_inventory{};
	};

	namespace dungeon
	{
		export auto get_delta(GAME::DIRECTION direction) -> ALLEGRO::POINT<int32_t>;
	}
}