export module game:boardgame.treasure;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :boardgame.base;

namespace game
{
	namespace boardgame
	{
		export class treasure_t
		{
		public:
			treasure_t();
			~treasure_t();
			auto on_update() -> int32_t;
			auto on_render() -> void;
			auto get_bitmap() const -> const ALLEGRO::BITMAP&;
			auto set_bitmap(const ALLEGRO::BITMAP& bitmap) -> void;
			auto get_position() const->const ALLEGRO::POINT<float>&;
			auto set_position(const ALLEGRO::POINT<float>& position) -> void;
			auto get_marker() -> int32_t;
			auto set_marker(int32_t marker) -> void;
			auto get_type() const->GAME::BOARDGAME::TREASURE::TYPE;
			auto set_type(GAME::BOARDGAME::TREASURE::TYPE type) -> void;
			auto get_state() const->GAME::BOARDGAME::TREASURE::STATE;
			auto set_state(GAME::BOARDGAME::TREASURE::STATE state) -> void;

		private:
			ALLEGRO::BITMAP m_bitmap{};
			ALLEGRO::POINT<float> m_position{};
			int32_t m_marker{ 0 };
			GAME::BOARDGAME::TREASURE::TYPE m_type{ GAME::BOARDGAME::TREASURE::TYPE::INVALID };
			GAME::BOARDGAME::TREASURE::STATE m_state{ GAME::BOARDGAME::TREASURE::STATE::INVALID };
		};
	}
}